/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.util.Collection;
import org.nuiton.i18n.I18n;

public class AddSpeciesProtocolAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    public AddSpeciesProtocolAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected void doAction() throws Exception {
        EditProtocolUI ui = (EditProtocolUI)this.getUI();
        EditProtocolSpeciesTableModel tableModel = ((EditProtocolUIHandler)this.handler).getTableModel();
        Species species = (Species)ui.getSpeciesComboBox().getSelectedItem();
        Preconditions.checkNotNull((Object)species, (Object)"Can't add a speciesProtocol with a null species");
        Preconditions.checkArgument((boolean)species.isReferenceTaxon(), (Object)"Can't add a speciesProtocol with a not referent species");
        Integer taxonId = species.getReferenceTaxonId();
        String taxonIdStr = String.valueOf(taxonId);
        Collection<Species> allSynonyms = ((EditProtocolUIModel)this.getModel()).getAllSynonyms(taxonIdStr);
        ((EditProtocolUIModel)this.getModel()).getAllSynonyms().removeAll(allSynonyms);
        ui.getSpeciesComboBox().getHandler().removeItem((Object)species);
        EditProtocolSpeciesRowModel protocol = tableModel.createNewRow();
        protocol.setSpecies(species);
        tableModel.addNewRow(protocol);
        ((EditProtocolUIModel)this.getModel()).setModify(true);
        String speciesStr = this.decorate(species);
        this.sendMessage(I18n._((String)"tutti.flash.info.species.add.to.protocol", (Object[])new Object[]{speciesStr}));
    }
}

