/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.TuttiDataContext;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.UIMessageNotifier;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiUIAction;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.editor.SimpleTimeEditor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.util.decorator.JXPathDecorator;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public abstract class AbstractTuttiUIHandler<M, UI extends TuttiUI<M, ?>>
implements UIMessageNotifier {
    private static final Log log = LogFactory.getLog(AbstractTuttiUIHandler.class);
    protected final TuttiUIContext context;
    protected final UI ui;
    public static final String CONFIRMATION_FORMAT = "<html>%s<hr/><br/>%s</html>";
    public static final String WARNING_FORMAT = "<html>%s<hr/></html>";

    public abstract void beforeInitUI();

    public abstract void afterInitUI();

    public abstract void onCloseUI();

    public abstract SwingValidator<M> getValidator();

    protected AbstractTuttiUIHandler(TuttiUIContext context, UI ui) {
        this.context = context;
        this.ui = ui;
    }

    public DefaultComboBoxModel newComboModel(Object ... items) {
        return new DefaultComboBoxModel<Object>(items);
    }

    public final M getModel() {
        return this.ui.getModel();
    }

    public final UI getUI() {
        return this.ui;
    }

    @Override
    public void showInformationMessage(String message) {
        this.context.showInformationMessage(message);
    }

    public TuttiUIContext getContext() {
        return this.context;
    }

    public TuttiDataContext getDataContext() {
        return this.getContext().getDataContext();
    }

    public TuttiApplicationConfig getConfig() {
        return this.context.getConfig();
    }

    public void setText(KeyEvent event, String property) {
        JTextComponent field = (JTextComponent)event.getSource();
        String value = field.getText();
        TuttiUIUtil.setProperty(this.getModel(), property, value);
    }

    public void setBoolean(ItemEvent event, String property) {
        boolean value = event.getStateChange() == 1;
        TuttiUIUtil.setProperty(this.getModel(), property, value);
    }

    public void setDate(ActionEvent event, String property) {
        JXDatePicker field = (JXDatePicker)event.getSource();
        Date value = field.getDate();
        TuttiUIUtil.setProperty(this.getModel(), property, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectListData(ListSelectionEvent event, String property) {
        if (!event.getValueIsAdjusting()) {
            JList list = (JList)event.getSource();
            ListSelectionModel selectionModel = list.getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                LinkedList selectedList = Lists.newLinkedList();
                for (int index : list.getSelectedIndices()) {
                    Object o = list.getModel().getElementAt(index);
                    selectedList.add(o);
                }
                TuttiUIUtil.setProperty(this.getModel(), property, selectedList);
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    public void openDialog(TuttiUI dialogContent, String title, Dimension dim) {
        Component topestUI = this.getTopestUI();
        JDialog result = topestUI instanceof Frame ? new JDialog((Frame)topestUI, title, true) : new JDialog((Dialog)topestUI, title, true);
        result.add((Component)((Object)dialogContent));
        result.setResizable(true);
        result.setSize(dim);
        Object handler = dialogContent.getHandler();
        if (handler instanceof Cancelable) {
            JRootPane rootPane = result.getRootPane();
            KeyStroke shortcutClosePopup = this.getConfig().getShortcutClosePopup();
            rootPane.getInputMap(2).put(shortcutClosePopup, "close");
            rootPane.getActionMap().put("close", new AbstractAction((AbstractTuttiUIHandler)handler){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ AbstractTuttiUIHandler val$handler;
                {
                    this.val$handler = abstractTuttiUIHandler2;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Cancelable)((Object)this.val$handler)).cancel();
                }
            });
        }
        result.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component)e.getSource();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Destroy ui " + ui));
                }
                JAXXUtil.destroy((Component)ui);
            }
        });
        SwingUtil.center((Component)this.getContext().getMainUI(), (Component)result);
        result.setVisible(true);
    }

    public void closeDialog(TuttiUI ui) {
        ((JDialog)SwingUtil.getParentContainer((Object)ui, JDialog.class)).setVisible(false);
    }

    public int askSaveBeforeLeaving(String message) {
        String htmlMessage = String.format(CONFIRMATION_FORMAT, message, I18n._((String)"tutti.common.askSaveBeforeLeaving.help", (Object[])new Object[0]));
        int result = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n._((String)"tutti.common.askSaveBeforeLeaving.title", (Object[])new Object[0]), 1, 3);
        return result;
    }

    public boolean askCancelEditBeforeLeaving(String message) {
        String htmlMessage = String.format(CONFIRMATION_FORMAT, message, I18n._((String)"tutti.common.askCancelEditBeforeLeaving.help", (Object[])new Object[0]));
        int i = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n._((String)"tutti.common.askCancelEditBeforeLeaving.title", (Object[])new Object[0]), 2, 3);
        boolean result = i == 0;
        return result;
    }

    public boolean askOverwriteFile(File file) {
        boolean result;
        if (file.exists()) {
            String htmlMessage = String.format(CONFIRMATION_FORMAT, I18n._((String)"tutti.common.askOverwriteFile.message", (Object[])new Object[]{file}), I18n._((String)"tutti.common.askOverwriteFile.help", (Object[])new Object[0]));
            result = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n._((String)"tutti.common.askOverwriteFile.title", (Object[])new Object[0]), 2, 3) == 0;
        } else {
            result = true;
        }
        return result;
    }

    protected Component getTopestUI() {
        TuttiActionUI actionUI = this.getContext().getActionUI();
        Window result = actionUI.isVisible() ? actionUI : this.getContext().getMainUI();
        return result;
    }

    protected void initUI(TuttiUI ui) {
        for (Map.Entry entry : ui.get$objectMap().entrySet()) {
            AbstractButton abstractButton;
            Class actionName;
            Object component = entry.getValue();
            if (component instanceof NumberEditor) {
                this.initNumberEditor((NumberEditor)component);
                continue;
            }
            if (component instanceof JXDatePicker) {
                this.initDatePicker((JXDatePicker)component);
                continue;
            }
            if (component instanceof SimpleTimeEditor) {
                this.initTimeEditor((SimpleTimeEditor)((Object)component));
                continue;
            }
            if (component instanceof ButtonAttachment) {
                this.initButtonAttachment((ButtonAttachment)component);
                continue;
            }
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                Boolean strongStyle = (Boolean)jLabel.getClientProperty("strongStyle");
                Boolean italicStyle = (Boolean)jLabel.getClientProperty("italicStyle");
                boolean addHtml = strongStyle != null && strongStyle != false || italicStyle != null && italicStyle != false;
                if (!addHtml) continue;
                String text = jLabel.getText();
                if (strongStyle != null && strongStyle.booleanValue()) {
                    text = "<strong>" + text + "</strong>";
                }
                if (italicStyle != null && italicStyle.booleanValue()) {
                    text = "<em>" + text + "</em>";
                }
                jLabel.setText("<html>" + text + "</html>");
                continue;
            }
            if (component instanceof JTextField) {
                JTextField jTextField = (JTextField)component;
                Boolean computed = (Boolean)jTextField.getClientProperty("computed");
                if (computed == null || !computed.booleanValue()) continue;
                Font font = jTextField.getFont().deriveFont(2);
                jTextField.setFont(font);
                jTextField.setEditable(computed == false);
                jTextField.setEnabled(computed == false);
                jTextField.setDisabledTextColor(this.getConfig().getColorComputedWeights());
                continue;
            }
            if (!(component instanceof AbstractButton) || (actionName = (Class)(abstractButton = (AbstractButton)component).getClientProperty("tuttiAction")) == null) continue;
            this.initAction(abstractButton, actionName);
        }
    }

    protected void initButtonAttachment(ButtonAttachment component) {
        component.init();
    }

    protected <A extends AbstractTuttiAction> void initAction(AbstractButton abstractButton, Class<A> actionName) {
        TuttiUIAction<A> action = this.createUIAction(abstractButton, actionName);
        abstractButton.setAction(action);
    }

    public <A extends AbstractTuttiAction> TuttiUIAction<A> createUIAction(AbstractButton abstractButton, Class<A> actionName) {
        try {
            A logicAction = this.createLogicAction(actionName);
            TuttiUIAction<A> result = new TuttiUIAction<A>(abstractButton, logicAction);
            return result;
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not instanciate action " + actionName, (Throwable)e);
        }
    }

    public <A extends AbstractTuttiAction> A createLogicAction(Class<A> actionName) {
        try {
            AbstractTuttiUIHandler handler = this;
            if (AbstractMainUITuttiAction.class.isAssignableFrom(actionName) && this.getContext().getMainUI() != null) {
                handler = this.getContext().getMainUI().getHandler();
            }
            AbstractTuttiAction result = (AbstractTuttiAction)((Object)ConstructorUtils.invokeConstructor(actionName, (Object[])new Object[]{handler}));
            return (A)((Object)result);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instanciate action " + actionName, e);
        }
    }

    public <A extends AbstractTuttiAction> A getLogicAction(AbstractButton b) {
        Action action = b.getAction();
        Preconditions.checkNotNull((Object)action);
        Preconditions.checkState((boolean)(action instanceof TuttiUIAction));
        return ((TuttiUIAction)action).getLogicAction();
    }

    protected void doAction(AbstractButton button, ActionEvent event) {
        button.getAction().actionPerformed(event);
    }

    protected boolean quitScreen(boolean modelIsValid, boolean modelIsModify, String askGiveUpMessage, String askSaveMessage, Action saveAction) {
        boolean result;
        if (!modelIsValid) {
            result = this.askCancelEditBeforeLeaving(askGiveUpMessage);
        } else if (modelIsModify) {
            int answer = this.askSaveBeforeLeaving(askSaveMessage);
            switch (answer) {
                case 0: {
                    saveAction.actionPerformed(null);
                    result = true;
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    protected void registerValidators(SwingValidator ... validators) {
        MainUI main = this.context.getMainUI();
        Preconditions.checkNotNull((Object)main, (Object)"No mainUI registred in application context");
        MainUIHandler handler = main.getHandler();
        handler.clearValidators();
        for (SwingValidator validator : validators) {
            handler.registerValidator(validator);
        }
    }

    public void clearValidators() {
        MainUI main = this.context.getMainUI();
        Preconditions.checkNotNull((Object)main, (Object)"No mainUI registred in application context");
        MainUIHandler handler = main.getHandler();
        handler.clearValidators();
    }

    protected <E extends Serializable> void initBeanFilterableComboBox(BeanFilterableComboBox<E> comboBox, List<E> data, E selectedData) {
        this.initBeanFilterableComboBox(comboBox, data, selectedData, null);
    }

    protected <E extends Serializable> void initBeanFilterableComboBox(BeanFilterableComboBox<E> comboBox, List<E> data, E selectedData, String decoratorContext) {
        Preconditions.checkNotNull(comboBox, (Object)"No comboBox!");
        Class beanType = comboBox.getBeanType();
        Preconditions.checkNotNull((Object)beanType, (Object)"No beanType on the combobox!");
        Decorator decorator = this.getDecorator(beanType, decoratorContext);
        if (data == null) {
            data = Lists.newArrayList();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("entity comboBox list [" + beanType.getName() + "] : " + (data == null ? 0 : data.size())));
        }
        comboBox.init((JXPathDecorator)decorator, (List)data);
        comboBox.setSelectedItem(selectedData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("combo [" + beanType.getName() + "] : " + comboBox.getData().size()));
        }
    }

    protected <E extends Serializable> void initBeanComboBox(BeanComboBox<E> comboBox, List<E> data, E selectedData) {
        this.initBeanComboBox(comboBox, data, selectedData, null);
    }

    protected <E extends Serializable> void initBeanComboBox(BeanComboBox<E> comboBox, List<E> data, E selectedData, String decoratorContext) {
        Preconditions.checkNotNull(comboBox, (Object)"No comboBox!");
        Class beanType = comboBox.getBeanType();
        Preconditions.checkNotNull((Object)beanType, (Object)"No beanType on the combobox!");
        Decorator decorator = this.getDecorator(beanType, decoratorContext);
        if (data == null) {
            data = Lists.newArrayList();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("entity comboBox list [" + beanType.getName() + "] : " + (data == null ? 0 : data.size())));
        }
        comboBox.init((JXPathDecorator)decorator, (List)data);
        comboBox.setSelectedItem(selectedData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("combo [" + beanType.getName() + "] : " + comboBox.getData().size()));
        }
    }

    protected <E extends IdAware> void initBeanList(BeanDoubleList<E> list, List<E> data, List<E> selectedData) {
        Preconditions.checkNotNull(list, (Object)"No list!");
        Class beanType = list.getBeanType();
        Preconditions.checkNotNull((Object)beanType, (Object)"No beanType on the double list!");
        DecoratorService decoratorService = this.context.getDecoratorService();
        Decorator decorator = decoratorService.getDecoratorByType(beanType);
        if (log.isInfoEnabled()) {
            log.info((Object)("entity list [" + beanType.getName() + "] : " + (data == null ? 0 : data.size())));
        }
        list.init((JXPathDecorator)decorator, data, selectedData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Jlist [" + beanType.getName() + "] : " + list.getUniverseList().getModel().getSize()));
        }
    }

    protected void initNumberEditor(NumberEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init number editor " + editor.getName()));
        }
        editor.init();
        Number model = editor.getModel();
        if (model != null) {
            editor.setModel(null);
            editor.setModel(model);
        }
    }

    protected void initTimeEditor(SimpleTimeEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init time editor " + editor.getName() + " for property " + editor.getModel().getProperty()));
        }
        editor.init();
    }

    protected void initDatePicker(final JXDatePicker picker) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("disable JXDatePicker editor" + picker.getName()));
        }
        String dateFormat = this.getConfig().getDateFormat();
        picker.setFormats(new String[]{dateFormat});
        picker.getEditor().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                block2: {
                    try {
                        picker.commitEdit();
                    }
                    catch (ParseException ex) {
                        if (!log.isDebugEnabled()) break block2;
                        log.debug((Object)"format error", (Throwable)ex);
                    }
                }
            }
        });
    }

    public <O> Decorator<O> getDecorator(Class<O> type, String name) {
        DecoratorService decoratorService = this.context.getDecoratorService();
        Preconditions.checkNotNull(type);
        Decorator<DecoratorService.LabelAware> decorator = decoratorService.getDecoratorByType(type, name);
        if (decorator == null && DecoratorService.LabelAware.class.isAssignableFrom(type)) {
            decorator = this.getDecorator(DecoratorService.LabelAware.class, null);
        }
        Preconditions.checkNotNull((Object)decorator);
        return decorator;
    }

    protected String decorate(Object object) {
        return this.decorate(object, null);
    }

    protected String decorate(Object object, String context) {
        String result = "";
        if (object != null) {
            this.getDecorator(object.getClass(), context).toString(object);
        }
        return result;
    }

    protected <O> ListCellRenderer newListCellRender(Class<O> type) {
        return this.newListCellRender(type, null);
    }

    protected <O> ListCellRenderer newListCellRender(Class<O> type, String name) {
        Decorator<O> decorator = this.getDecorator(type, name);
        return this.newListCellRender(decorator);
    }

    protected <O> ListCellRenderer newListCellRender(Decorator<O> decorator) {
        Preconditions.checkNotNull(decorator);
        DecoratorListCellRenderer result = new DecoratorListCellRenderer(decorator);
        return result;
    }

    protected void listenValidatorValid(SimpleBeanValidator validator, final AbstractTuttiBeanUIModel model) {
        validator.addPropertyChangeListener("valid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Model [" + (Object)((Object)model) + "] pass to valid state [" + evt.getNewValue() + "]"));
                }
                model.setValid((Boolean)evt.getNewValue());
            }
        });
    }

    protected void listModelIsModify(AbstractTuttiBeanUIModel model) {
        model.addPropertyChangeListener(new PropertyChangeListener(){
            final Set<String> excludeProperties;
            {
                this.excludeProperties = AbstractTuttiUIHandler.this.getPropertiesToIgnore();
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!this.excludeProperties.contains(evt.getPropertyName())) {
                    ((AbstractTuttiBeanUIModel)((Object)evt.getSource())).setModify(true);
                }
            }
        });
    }

    protected Set<String> getPropertiesToIgnore() {
        return Sets.newHashSet((Object[])new String[]{"modify", "valid"});
    }

    protected void closeUI(TuttiUI ui) {
        ((AbstractTuttiUIHandler)ui.getHandler()).onCloseUI();
    }

    protected <B> void changeValidatorContext(String newContext, SwingValidator<B> validator) {
        Object bean = validator.getBean();
        validator.setContext(newContext);
        validator.setBean(bean);
    }
}

