/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.hibernate;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.type.Type;
import org.springframework.dao.DataIntegrityViolationException;

public class HibernateDaoSupport
extends org.springframework.orm.hibernate3.support.HibernateDaoSupport {
    protected boolean debugLoadAsGet = false;

    protected Object[] queryUnique(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Object result = query.uniqueResult();
        return (Object[])result;
    }

    protected <T> T queryUniqueTyped(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Object result = query.uniqueResult();
        return (T)result;
    }

    protected Iterator<Object[]> queryIterator(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Iterator result = query.iterate();
        return result;
    }

    protected <T> Iterator<T> queryIteratorTyped(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Iterator result = query.iterate();
        return result;
    }

    protected List<Object[]> queryList(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        List result = query.list();
        return result;
    }

    protected <T> List<T> queryListTyped(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        List result = query.list();
        return result;
    }

    protected int queryUpdate(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        int result = query.executeUpdate();
        return result;
    }

    protected Query createQuery(String queryName, Object ... params) {
        Query query = this.getSession(false).getNamedQuery(queryName);
        if (params.length > 0) {
            Preconditions.checkArgument((params.length % 3 == 0 ? 1 : 0) != 0, (Object)"Params must be tuple (paramName, paramType, paramValue)");
            int nbParams = params.length / 3;
            for (int i = 0; i < nbParams; ++i) {
                String paramName = (String)params[3 * i];
                Type paramType = (Type)params[3 * i + 1];
                Object paramValue = params[3 * i + 2];
                query.setParameter(paramName, paramValue, paramType);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("query [" + queryName + "] (param " + i + " [" + paramName + '=' + paramValue + "])"));
            }
        }
        return query;
    }

    protected <T extends Serializable> T load(Class<? extends T> clazz, Serializable id) {
        Serializable load;
        if (this.debugLoadAsGet && (load = (Serializable)this.getSession(false).get(clazz, id)) == null) {
            throw new DataIntegrityViolationException("Unable to load entity " + clazz.getName() + " with id=" + id + " : not found in database.");
        }
        load = (Serializable)this.getSession(false).load(clazz, id);
        return (T)load;
    }

    protected <T extends Serializable> T get(Class<? extends T> clazz, Serializable id) {
        Serializable load = (Serializable)this.getSession(false).get(clazz, id);
        return (T)load;
    }
}

