/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.RessourceClassLoader;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.ClosedPersistenceService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.service.referential.TuttiReferentialImportExportService;
import fr.ifremer.tutti.service.referential.TuttiReferentialSynchronizeService;
import fr.ifremer.tutti.ui.swing.TuttiDataContext;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.util.TuttiErrorHelper;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.UIMessageNotifier;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import jaxx.runtime.swing.help.JAXXHelpUIHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.i18n.init.UserI18nInitializer;
import org.nuiton.widget.SwingSession;

public class TuttiUIContext
extends AbstractBean
implements Closeable,
UIMessageNotifier,
JAXXHelpUIHandler {
    public static final String VALIDATION_CONTEXT_EDIT = "edit";
    public static final String VALIDATION_CONTEXT_VALIDATE = "validate";
    private static final Log log = LogFactory.getLog(TuttiUIContext.class);
    public static final String PROPERTY_PROGRAM_ID = "programId";
    public static final String PROPERTY_CRUISE_ID = "cruiseId";
    public static final String PROPERTY_PROTOCOL_ID = "protocolId";
    public static final String PROPERTY_SCREEN = "screen";
    public static final String PROPERTY_PROGRAM_FILLED = "programFilled";
    public static final String PROPERTY_CRUISE__FILLED = "cruiseFilled";
    public static final String PROPERTY_PROTOCOL_FILLED = "protocolFilled";
    public static final String PROPERTY_VALIDATION_CONTEXT = "validationContext";
    public static final String PROPERTY_BUSY = "busy";
    public static final String PROPERTY_HIDE_BODY = "hideBody";
    public static final String PROPERTY_LOCALE = "locale";
    public static final Set<String> PROPERTIES_TO_SAVE = Sets.newHashSet((Object[])new String[]{"programId", "cruiseId", "protocolId", "locale"});
    public static final String PROPERTY_DB_EXIST = "dbExist";
    public static final String PROPERTY_DB_LOADED = "dbLoaded";
    private static TuttiUIContext applicationContext;
    protected final TuttiApplicationConfig config;
    protected final RessourceClassLoader resourceLoader;
    protected final TuttiServiceContext serviceContext;
    protected final SwingSession swingSession;
    protected final TuttiErrorHelper errorHelper;
    protected String programId;
    protected String cruiseId;
    protected String protocolId;
    protected TuttiDataContext dataContext;
    protected TuttiHelpBroker helpBroker;
    protected TuttiScreen screen;
    protected Locale locale;
    protected boolean busy;
    protected boolean hideBody;
    protected final Set<UIMessageNotifier> messageNotifiers;
    private String validationContext;
    private MainUI mainUI;
    private TuttiActionUI actionUI;
    private boolean dbExist;
    private boolean dbLoaded;
    private Properties helpMapping;

    public static TuttiUIContext newContext(TuttiApplicationConfig config) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkState((applicationContext == null ? 1 : 0) != 0, (Object)"Application context was already opened!");
        applicationContext = new TuttiUIContext(config);
        return applicationContext;
    }

    public static TuttiUIContext getApplicationContext() {
        return applicationContext;
    }

    public static TuttiErrorHelper getErrorHelper() {
        return TuttiUIContext.applicationContext.errorHelper;
    }

    protected TuttiUIContext(TuttiApplicationConfig config) {
        this.config = config;
        this.resourceLoader = new RessourceClassLoader(Thread.currentThread().getContextClassLoader());
        this.serviceContext = new TuttiServiceContext(this.resourceLoader, config.getServiceConfig());
        this.swingSession = new SwingSession(this.getConfig().getUIConfigFile(), false);
        this.errorHelper = new TuttiErrorHelper(this);
        this.dataContext = new TuttiDataContext(this);
        UIMessageNotifier logMessageNotifier = new UIMessageNotifier(){

            @Override
            public void showInformationMessage(String message) {
                if (log.isInfoEnabled()) {
                    log.info((Object)message);
                }
            }
        };
        this.messageNotifiers = Sets.newHashSet();
        this.addMessageNotifier(logMessageNotifier);
    }

    public PersistenceService getPersistenceService() {
        PersistenceService service;
        if (this.useRealPersistenceService()) {
            service = this.dataContext.service;
            if (service == null) {
                service = (PersistenceService)this.serviceContext.getService(PersistenceService.class);
                this.dataContext.open(service);
            }
        } else {
            service = (PersistenceService)this.serviceContext.getService(ClosedPersistenceService.class);
        }
        return service;
    }

    public DecoratorService getDecoratorService() {
        return (DecoratorService)this.serviceContext.getService(DecoratorService.class);
    }

    public TuttiReferentialSynchronizeService getTuttiReferentialSynchronizeService() {
        return (TuttiReferentialSynchronizeService)this.serviceContext.getService(TuttiReferentialSynchronizeService.class);
    }

    public TuttiProtocolImportExportService getTuttiProtocolImportExportService() {
        return (TuttiProtocolImportExportService)this.serviceContext.getService(TuttiProtocolImportExportService.class);
    }

    public TuttiReferentialImportExportService getTuttiReferentialImportExportService() {
        return (TuttiReferentialImportExportService)this.serviceContext.getService(TuttiReferentialImportExportService.class);
    }

    public boolean useRealPersistenceService() {
        return this.isDbExist() && this.isDbLoaded();
    }

    public PersistenceService reloadPersistenceService() {
        try {
            this.serviceContext.close();
        }
        catch (IOException e) {
            throw new TuttiTechnicalException("Could not close services", e);
        }
        this.dataContext.close();
        return this.getPersistenceService();
    }

    public TuttiApplicationConfig getConfig() {
        return this.config;
    }

    public SwingSession getSwingSession() {
        return this.swingSession;
    }

    public String getProgramId() {
        return this.programId;
    }

    public String getCruiseId() {
        return this.cruiseId;
    }

    public String getProtocolId() {
        return this.protocolId;
    }

    public boolean isCruiseFilled() {
        return this.isProgramFilled() && StringUtils.isNotBlank((CharSequence)this.cruiseId);
    }

    public boolean isProtocolFilled() {
        return StringUtils.isNotBlank((CharSequence)this.protocolId);
    }

    public boolean isProgramFilled() {
        return StringUtils.isNotBlank((CharSequence)this.programId);
    }

    public TuttiScreen getScreen() {
        return this.screen;
    }

    public boolean isDbExist() {
        return this.dbExist;
    }

    public void setDbExist(boolean dbExist) {
        this.dbExist = dbExist;
        this.firePropertyChange(PROPERTY_DB_EXIST, null, dbExist);
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
        this.firePropertyChange(PROPERTY_BUSY, null, busy);
    }

    public boolean isHideBody() {
        return this.hideBody;
    }

    public void setHideBody(boolean hideBody) {
        this.hideBody = hideBody;
        this.firePropertyChange(PROPERTY_HIDE_BODY, null, hideBody);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.firePropertyChange(PROPERTY_LOCALE, null, locale);
    }

    public boolean isDbLoaded() {
        return this.dbLoaded;
    }

    public void setDbLoaded(boolean dbLoaded) {
        this.dbLoaded = dbLoaded;
        this.firePropertyChange(PROPERTY_DB_LOADED, null, dbLoaded);
    }

    public void setProgramId(String programId) {
        boolean oldProgramFilled = this.isProgramFilled();
        boolean oldCruiseFilled = this.isCruiseFilled();
        this.programId = programId;
        this.firePropertyChange(PROPERTY_PROGRAM_ID, -1, programId);
        this.firePropertyChange(PROPERTY_PROGRAM_FILLED, oldProgramFilled, this.isProgramFilled());
        this.firePropertyChange(PROPERTY_CRUISE__FILLED, oldCruiseFilled, this.isCruiseFilled());
    }

    public void setCruiseId(String cruiseId) {
        boolean oldValue = this.isCruiseFilled();
        this.cruiseId = cruiseId;
        this.firePropertyChange(PROPERTY_CRUISE_ID, -1, cruiseId);
        this.firePropertyChange(PROPERTY_CRUISE__FILLED, oldValue, this.isCruiseFilled());
    }

    public void setProtocolId(String protocolId) {
        boolean oldValue = this.isProtocolFilled();
        this.protocolId = protocolId;
        this.firePropertyChange(PROPERTY_PROTOCOL_ID, -1, protocolId);
        this.firePropertyChange(PROPERTY_PROTOCOL_FILLED, oldValue, this.isProtocolFilled());
    }

    public void setValidationContext(String validationContext) {
        String oldValue = this.getValidationContext();
        this.validationContext = validationContext;
        this.firePropertyChange(PROPERTY_VALIDATION_CONTEXT, oldValue, validationContext);
    }

    public String getValidationContext() {
        return this.validationContext;
    }

    public void setScreen(TuttiScreen screen) {
        TuttiScreen oldValue = this.getScreen();
        this.screen = screen;
        this.firePropertyChange(PROPERTY_SCREEN, (Object)oldValue, (Object)screen);
    }

    public TuttiDataContext getDataContext() {
        return this.dataContext;
    }

    public void init() {
        this.config.getServiceConfig().prepareDirectories();
        Thread.currentThread().setContextClassLoader(this.getResourceLoader());
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Close context on shutdown");
                }
                TuttiUIContext.this.close();
            }
        }));
        this.config.getServiceConfig().getPersistenceConfig().initConfig(this.getResourceLoader());
        File i18nDirectory = this.config.getI18nDirectory();
        if (!this.config.isFullLaunchMode() && (i18nDirectory = new File(this.config.getDataDirectory(), "i18n")).exists()) {
            TuttiIOUtil.cleanDirectory(i18nDirectory, "Could not delete i18n cache at " + i18nDirectory);
        }
        TuttiIOUtil.forceMkdir(i18nDirectory, "Could not create i18n at " + i18nDirectory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("I18N directory: " + i18nDirectory));
        }
        Locale i18nLocale = this.config.getI18nLocale();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Starts i18n with locale [%s] at [%s]", i18nLocale, i18nDirectory));
        }
        I18n.init((I18nInitializer)new UserI18nInitializer(i18nDirectory, new DefaultI18nInitializer("tutti-i18n")), (Locale)i18nLocale);
        File helpDirectory = this.config.getHelpDirectory();
        if (!this.config.isFullLaunchMode() && !helpDirectory.exists()) {
            helpDirectory = new File(this.config.getDataDirectory(), "help");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Help directory: " + helpDirectory));
        }
        TuttiIOUtil.forceMkdir(helpDirectory, "Could not create helpDirectory at " + helpDirectory);
        String mappingProperties = "/tutti-help-" + i18nLocale.getLanguage() + ".properties";
        try {
            InputStream resourceAsStream = this.getClass().getResourceAsStream(mappingProperties);
            this.helpMapping = new Properties();
            this.helpMapping.load(resourceAsStream);
        }
        catch (Exception eee) {
            log.error((Object)("Failed to load help mapping file at '" + mappingProperties + "'"), (Throwable)eee);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Starts help with locale at [%s]", helpDirectory));
        }
        this.setActionUI(new TuttiActionUI(null, this));
    }

    public void open() {
        this.setLocale(this.config.getI18nLocale());
        if (this.programId == null) {
            this.setProgramId(this.config.getProgramId());
        }
        if (this.cruiseId == null) {
            this.setCruiseId(this.config.getCruiseId());
        }
        if (this.protocolId == null) {
            this.setProtocolId(this.config.getProtocolId());
        }
        boolean dbExists = this.config.getServiceConfig().getPersistenceConfig().isDbExists();
        this.setDbExist(dbExists);
        if (!dbExists) {
            this.setProtocolId(null);
            this.setProgramId(null);
            this.setCruiseId(null);
            this.setDbLoaded(false);
        }
        this.saveContextToConfig();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PROPERTIES_TO_SAVE.contains(evt.getPropertyName())) {
                    TuttiUIContext.this.saveContextToConfig();
                }
            }
        });
    }

    @Override
    public void close() {
        PropertyChangeListener[] listeners;
        this.messageNotifiers.clear();
        this.programId = null;
        this.cruiseId = null;
        this.protocolId = null;
        this.validationContext = null;
        IOUtils.closeQuietly((Closeable)this.dataContext);
        this.setScreen(null);
        IOUtils.closeQuietly((Closeable)this.serviceContext);
        for (PropertyChangeListener listener : listeners = this.getPropertyChangeListeners()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove listener: " + listener));
            }
            this.removePropertyChangeListener(listener);
        }
        this.setMainUI(null);
        if (this.actionUI != null) {
            this.actionUI.getModel().clear();
        }
        this.setActionUI(null);
    }

    protected void saveContextToConfig() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save config (programId: " + this.programId + ", cruiseId: " + this.cruiseId + ", protocolId: " + this.protocolId + ", locale: " + this.locale + ")"));
        }
        this.config.setProgramId(this.programId);
        this.config.setCruiseId(this.cruiseId);
        this.config.setProtocolId(this.protocolId);
        this.config.setI18nLocale(this.locale);
        this.config.save();
    }

    public void addMessageNotifier(UIMessageNotifier messageNotifier) {
        this.messageNotifiers.add(messageNotifier);
    }

    public void removeMessageNotifier(UIMessageNotifier messageNotifier) {
        this.messageNotifiers.remove(messageNotifier);
    }

    @Override
    public void showInformationMessage(String message) {
        for (UIMessageNotifier messageNotifier : this.messageNotifiers) {
            messageNotifier.showInformationMessage(message);
        }
    }

    public RessourceClassLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setMainUI(MainUI mainUI) {
        this.mainUI = mainUI;
    }

    public MainUI getMainUI() {
        return this.mainUI;
    }

    public void setActionUI(TuttiActionUI actionUI) {
        this.actionUI = actionUI;
    }

    public TuttiActionUI getActionUI() {
        return this.actionUI;
    }

    public void clearDbContext() {
        this.protocolId = null;
        this.programId = null;
        this.cruiseId = null;
        this.saveContextToConfig();
    }

    public void checkDbContext() {
        PersistenceService service = this.getPersistenceService();
        if (this.isProtocolFilled() && !service.isProtocolExist(this.protocolId)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Remove invalid protocolId: " + this.protocolId));
            }
            this.setProtocolId(null);
        }
        if (this.isProgramFilled()) {
            Program program = service.getProgram(this.programId);
            if (program == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Remove invalid programId: " + this.programId));
                }
                this.setProgramId(null);
                this.setCruiseId(null);
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("ProgramId valid: " + this.programId));
                }
                this.setProgramId(this.programId);
                if (this.isCruiseFilled()) {
                    Cruise cruise = service.getCruise(this.cruiseId);
                    if (cruise != null && !cruise.getProgram().getId().equals(this.programId)) {
                        cruise = null;
                    }
                    if (cruise == null) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Remove invalid cruiseId: " + this.cruiseId));
                        }
                        this.setCruiseId(null);
                    } else if (log.isInfoEnabled()) {
                        log.info((Object)("CruiseId valid: " + this.cruiseId));
                    }
                }
            }
        }
        this.saveContextToConfig();
    }

    public TuttiHelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public void setHelpBroker(TuttiHelpBroker helpBroker) {
        this.helpBroker = helpBroker;
    }

    public void showHelp(JAXXContext context, JAXXHelpBroker broker, String helpId) {
        String value;
        if (helpId == null) {
            helpId = broker.getDefaultID();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("show help " + helpId));
        }
        if ((value = (String)this.helpMapping.get(helpId)) == null) {
            throw new TuttiTechnicalException("Could not find help page for " + helpId);
        }
        File helpDirectory = this.getConfig().getHelpDirectoryWithLocale();
        URI resolvedUri = helpDirectory.toURI().resolve(value);
        TuttiUIUtil.openLink(resolvedUri);
    }

    public void reloadDecoratorService() {
        this.serviceContext.reloadService(DecoratorService.class);
    }
}

