/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.awt.visitor.BuildTreeVisitor;
import jaxx.runtime.awt.visitor.ComponentTreeNode;
import jaxx.runtime.awt.visitor.GetCompopentAtPointVisitor;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.swing.help.JAXXHelpUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuttiHelpBroker
extends JAXXHelpBroker {
    private static final Log log = LogFactory.getLog(TuttiHelpBroker.class);

    public TuttiHelpBroker(String defaultID) {
        super("tutti", "help", defaultID, (JAXXHelpUIHandler)TuttiUIContext.getApplicationContext());
    }

    public void prepareUI(JAXXObject c) {
        if (c == null) {
            throw new NullPointerException("parameter c can not be null!");
        }
        AbstractButton help = this.getShowHelpButton(c);
        if (help != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("attach context to showhelp button " + c));
            }
            help.putClientProperty("jaxxcontext", c);
            ActionListener listener = this.getShowHelpAction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding tracking action " + listener));
            }
            help.addActionListener(listener);
            if (log.isDebugEnabled()) {
                log.debug((Object)("done for " + c));
            }
        }
    }

    public String findHelpId(Component comp) {
        String result;
        JAXXHelpUI parentContainer = (JAXXHelpUI)SwingUtil.getParent((Object)comp, JAXXHelpUI.class);
        if (parentContainer != null && this != parentContainer.getBroker()) {
            JAXXHelpBroker broker = parentContainer.getBroker();
            result = broker.findHelpId(comp);
        } else {
            result = super.findHelpId(comp);
        }
        return result;
    }

    public Component getDeppestComponent(Component mouseComponent, MouseEvent event) {
        ComponentTreeNode tree = BuildTreeVisitor.buildTree((Component)mouseComponent);
        Point point = event.getPoint();
        Component component = GetCompopentAtPointVisitor.get((ComponentTreeNode)tree, (Point)point);
        if (log.isInfoEnabled()) {
            log.info((Object)("Component at (" + point + "): " + component));
        }
        return component;
    }
}

