/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportProtocolSpeciesAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ImportProtocolSpeciesAction.class);
    private File file;

    public ImportProtocolSpeciesAction(EditProtocolUIHandler handler) {
        super(handler, "importProtocolSpecies", "import", I18n._((String)"tutti.action.importProtocolSpecies", (Object[])new Object[0]), I18n._((String)"tutti.action.importProtocolSpecies.tip", (Object[])new Object[0]), false);
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean doAction;
        this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.protocolSpeciesImportFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseProtocolSpeciesFile", (Object[])new Object[0]), null, "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
        boolean bl = doAction = this.file != null;
        if (doAction) {
            super.prepareAction(event);
        }
        return doAction;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        this.file = null;
    }

    @Override
    protected void doAction(ActionEvent e) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol species file: " + this.file));
        }
        EditProtocolUIHandler handler = (EditProtocolUIHandler)this.getHandler();
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        TuttiProtocol protocol = (TuttiProtocol)model.toBean();
        TuttiProtocolImportExportService service = this.getService(TuttiProtocolImportExportService.class);
        service.importProtocolSpecies(this.file, protocol, model.getAllCaracteristic(), model.getAllReferentSpeciesByTaxonId());
        BeanComboBox<Species> speciesComboBox = ((EditProtocolUI)this.getUI()).getSpeciesComboBox();
        List<EditProtocolSpeciesRowModel> rows = handler.toRows(speciesComboBox.getData(), protocol.getSpecies());
        speciesComboBox.getHandler().sortData();
        handler.selectFirstInCombo(speciesComboBox);
        model.setRows(rows);
        this.sendMessage(I18n._((String)"tutti.flash.information.species.imported.in.protocol", (Object[])new Object[]{this.file}));
    }
}

