/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound.impl;

import java.io.File;
import java.io.IOException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.store.FifoPolicy;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.LruPolicy;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.compound.CompoundStore;
import net.sf.ehcache.store.compound.factories.CapacityLimitedInMemoryFactory;
import net.sf.ehcache.store.compound.factories.DiskOverflowStorageFactory;

public final class OverflowToDiskStore
extends CompoundStore
implements CacheConfigurationListener {
    private final CapacityLimitedInMemoryFactory memoryFactory;
    private final DiskOverflowStorageFactory diskFactory;
    private final CacheConfiguration config;

    private OverflowToDiskStore(CapacityLimitedInMemoryFactory memory, DiskOverflowStorageFactory disk, CacheConfiguration config) {
        super(memory, config.isCopyOnRead(), config.isCopyOnWrite(), config.getCopyStrategy());
        this.memoryFactory = memory;
        this.diskFactory = disk;
        this.config = config;
    }

    public static OverflowToDiskStore create(Cache cache, String diskStorePath) {
        CacheConfiguration config = cache.getCacheConfiguration();
        DiskOverflowStorageFactory disk = new DiskOverflowStorageFactory(cache, diskStorePath);
        CapacityLimitedInMemoryFactory memory = new CapacityLimitedInMemoryFactory(disk, config.getMaxElementsInMemory(), OverflowToDiskStore.determineEvictionPolicy(config), cache.getCacheEventNotificationService());
        OverflowToDiskStore store = new OverflowToDiskStore(memory, disk, config);
        cache.getCacheConfiguration().addConfigurationListener(store);
        return store;
    }

    private static final Policy determineEvictionPolicy(CacheConfiguration config) {
        MemoryStoreEvictionPolicy policySelection = config.getMemoryStoreEvictionPolicy();
        if (policySelection.equals(MemoryStoreEvictionPolicy.LRU)) {
            return new LruPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.FIFO)) {
            return new FifoPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.LFU)) {
            return new LfuPolicy();
        }
        throw new IllegalArgumentException(policySelection + " isn't a valid eviction policy");
    }

    public boolean bufferFull() {
        return this.diskFactory.bufferFull();
    }

    public boolean containsKeyInMemory(Object key) {
        return this.memoryFactory.created(this.unretrievedGet(key));
    }

    public boolean containsKeyOffHeap(Object key) {
        return false;
    }

    public boolean containsKeyOnDisk(Object key) {
        return this.diskFactory.created(this.unretrievedGet(key));
    }

    public int getInMemorySize() {
        return this.memoryFactory.getSize();
    }

    public long getInMemorySizeInBytes() {
        return this.memoryFactory.getSizeInBytes();
    }

    public int getOffHeapSize() {
        return 0;
    }

    public long getOffHeapSizeInBytes() {
        return 0L;
    }

    public int getOnDiskSize() {
        return this.diskFactory.getSize();
    }

    public long getOnDiskSizeInBytes() {
        return this.diskFactory.getSizeInBytes();
    }

    public Policy getInMemoryEvictionPolicy() {
        return this.memoryFactory.getEvictionPolicy();
    }

    public void setInMemoryEvictionPolicy(Policy policy) {
        this.memoryFactory.setEvictionPolicy(policy);
    }

    public void diskCapacityChanged(int oldCapacity, int newCapacity) {
        this.diskFactory.setCapacity(newCapacity);
    }

    public void memoryCapacityChanged(int oldCapacity, int newCapacity) {
        this.memoryFactory.setCapacity(newCapacity);
    }

    public void loggingChanged(boolean oldValue, boolean newValue) {
    }

    public void registered(CacheConfiguration config) {
    }

    public void deregistered(CacheConfiguration config) {
    }

    public void timeToIdleChanged(long oldTimeToIdle, long newTimeToIdle) {
    }

    public void timeToLiveChanged(long oldTimeToLive, long newTimeToLive) {
    }

    public void expireElements() {
        this.memoryFactory.expireElements();
        this.diskFactory.expireElements();
    }

    public void flush() throws IOException {
        if (this.config.isClearOnFlush()) {
            for (Object key : this.getKeys()) {
                if (!this.containsKeyInMemory(key)) continue;
                this.remove(key);
            }
        }
    }

    public int getTerracottaClusteredSize() {
        return 0;
    }

    public File getDataFile() {
        return this.diskFactory.getDataFile();
    }

    public Object getMBean() {
        return null;
    }
}

