package fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology;

/*
 * #%L
 * Tutti :: UI
 * $Id: HydrologyTabUIHandler.java 349 2013-02-06 10:54:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/fishing/hydrology/HydrologyTabUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.CaracteristicTabUIHandler;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueEditor;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueRenderer;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;

import java.util.List;

/**
 * @author kmorin
 * @since 0.3
 */
public class HydrologyTabUIHandler extends CaracteristicTabUIHandler<HydrologyRowModel, HydrologyTabUIModel, HydrologyTableModel, HydrologyTabUI> {

    private final static Log log =
            LogFactory.getLog(HydrologyTabUIHandler.class);

//    protected Map<Caracteristic, Map<Type, Caracteristic>> availableGlobalCaracteristics;

    public HydrologyTabUIHandler(EditFishingOperationUI parentUi,
                                 HydrologyTabUI ui) {
        super(parentUi, ui,
              HydrologyRowModel.PROPERTY_VALUE
//              HydrologyRowModel.PROPERTY_GEAR_SHOOTING_START_VALUE,
//              HydrologyRowModel.PROPERTY_AVERAGE_VALUE,
//              HydrologyRowModel.PROPERTY_GEAR_SHOOTING_END_VALUE
        );
    }


    //------------------------------------------------------------------------//
    //-- CaracteristicTabUIHandler methods                                  --//
    //------------------------------------------------------------------------//

    @Override
    protected BeanComboBox<Caracteristic> getKeyCombo() {
        return ui.getNewRowKey();
    }

    @Override
    protected HydrologyTabUIModel createModel() {
        return new HydrologyTabUIModel();
    }

    @Override
    protected CaracteristicMap getCaracteristics(FishingOperation operation) {
        return operation.getHydrologyCaracteristics();
    }

    @Override
    protected List<String> getProtocolPmfmIds(TuttiProtocol protocol) {
        return protocol.getHydrologyPmfmId();
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiTableUIHandler methods                                --//
    //------------------------------------------------------------------------//

    @Override
    public JXTable getTable() {
        return ui.getHydrologyTable();
    }

//    @Override
//    protected boolean isRowValid(HydrologyRowModel row) {
//        //TODO
//        return row.getGearShootingStartValue() != null ||
//               row.getGearShootingEndValue() != null ||
//               row.getAverageValue() != null;
//    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

//    @Override
//    public void beforeInitUI() {
//        HydrologyTabUIModel model = new HydrologyTabUIModel();
//        ui.setContextValue(model);
//
//        model.addPropertyChangeListener(HydrologyTabUIModel.PROPERTY_AVAILABLE_CARACTERISTICS, new PropertyChangeListener() {
//
//            public void propertyChange(PropertyChangeEvent evt) {
//                List<Caracteristic> hydrologyPmfm = (List<Caracteristic>) evt.getNewValue();
//                availableGlobalCaracteristics = Maps.newHashMap();
//                if (hydrologyPmfm != null) {
//                    for (Caracteristic caracteristic : hydrologyPmfm) {
//                        String name = HydrologicCaracteristicUtil.getGlobalName(caracteristic.getName());
//                        Caracteristic globalCaracteristic = HydrologicCaracteristicUtil.createGlobalCaracteristic(name, caracteristic);
//                        Map<Type, Caracteristic> values = availableGlobalCaracteristics.get(globalCaracteristic);
//                        if (values == null) {
//                            values = Maps.newHashMap();
//                            availableGlobalCaracteristics.put(globalCaracteristic, values);
//                        }
//                        Type type = HydrologicCaracteristicUtil.getTypeOfCaracteristic(caracteristic);
//                        values.put(type, caracteristic);
//                    }
//                }
//            }
//        });
//    }

    @Override
    public void afterInitUI() {
        super.afterInitUI();

        JXTable table = getTable();

        // create table column model
        DefaultTableColumnModelExt columnModel =
                new DefaultTableColumnModelExt();

        {

            addColumnToModel(columnModel,
                             null,
                             newTableCellRender(Caracteristic.class, DecoratorService.CARACTERISTIC_WITH_UNIT),
                             HydrologyTableModel.KEY);
        }

        {
            addColumnToModel(columnModel,
                             new CaracteristicValueEditor(context),
                             new CaracteristicValueRenderer(context),
                             HydrologyTableModel.VALUE);
        }

//        {
//
//            addColumnToModel(columnModel,
//                             new CaracteristicValueEditor(context),
//                             new CaracteristicValueRenderer(context),
//                             HydrologyTableModel.GEAR_SHOOTING_START_VALUE);
//        }
//
//        {
//
//            addColumnToModel(columnModel,
//                             new CaracteristicValueEditor(context),
//                             new CaracteristicValueRenderer(context),
//                             HydrologyTableModel.GEAR_SHOOTING_END_VALUE);
//        }
//
//        {
//
//            addColumnToModel(columnModel,
//                             new CaracteristicValueEditor(context),
//                             new CaracteristicValueRenderer(context),
//                             HydrologyTableModel.AVERAGE_VALUE);
//        }

        // create table model
        HydrologyTableModel tableModel =
                new HydrologyTableModel(columnModel);

        table.setModel(tableModel);
        table.setColumnModel(columnModel);
        initTable(table);
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

//    @Override
//    public void reset(FishingOperation fishingOperation) {
//        HydrologyTableModel tableModel = getTableModel();
//        HydrologyTabUIModel model = getModel();
//
//        CaracteristicMap hydrologyCaracteristics = fishingOperation.getHydrologyCaracteristics();
//        if (hydrologyCaracteristics == null) {
//            hydrologyCaracteristics = new CaracteristicMap();
//        }
//        model.setCaracteristicMap(hydrologyCaracteristics);
//
//        TuttiProtocol protocol = TuttiUIUtil.getProtocol(ui);
//        List<String> gearPmfmIds = Lists.newArrayList();
//        if (protocol != null) {
//            List<String> protocolHydrologyPmfmId = protocol.getHydrologyPmfmId();
//            if (protocolHydrologyPmfmId != null) {
//                gearPmfmIds.addAll(protocolHydrologyPmfmId);
//            }
//        }
//
//        List<HydrologyRowModel> rows = Lists.newArrayList();
//        List<Caracteristic> caracteristicList = Lists.newArrayList();
//        List<Caracteristic> selectedCaracteristics = Lists.newArrayList(hydrologyCaracteristics.keySet());
//
//        List<Caracteristic> availableCaracteristics = model.getAvailableCaracteristics();
//        for (String id : gearPmfmIds) {
//            Caracteristic caracteristic = TuttiEntities.findById(availableCaracteristics, id);
//            if (!selectedCaracteristics.contains(caracteristic)) {
//                selectedCaracteristics.add(caracteristic);
//            }
//        }
//
//        Set<Caracteristic> globalCaracteristics = availableGlobalCaracteristics.keySet();
//
//        for (Caracteristic availableCaracteristic : globalCaracteristics) {
//            Map<Type, Caracteristic> caracteristics = availableGlobalCaracteristics.get(availableCaracteristic);
//
//            //should add the global caracteristic to the combo or to the table?
//            boolean selectedCaracteristic = false;
//            for (Caracteristic caracteristic : caracteristics.values()) {
//                selectedCaracteristic |= selectedCaracteristics.contains(caracteristic);
//            }
//
//            if (selectedCaracteristic) {
//                HydrologyRowModel row = tableModel.createNewRow();
//                row.setKey(availableCaracteristic);
//                row.setGearShootingStartValue(hydrologyCaracteristics.get(caracteristics.get(Type.START)));
//                row.setGearShootingEndValue(hydrologyCaracteristics.get(caracteristics.get(Type.END)));
//                row.setAverageValue(hydrologyCaracteristics.get(caracteristics.get(Type.AVERAGE)));
//                rows.add(row);
//
//            } else {
//                caracteristicList.add(availableCaracteristic);
//            }
//        }
//
//        model.setRows(rows);
//
//        ui.getNewRowKey().setData(caracteristicList);
//        selectFirstInCombo(ui.getNewRowKey());
//        model.setModify(false);
//    }

    @Override
    public void removeCaracteristic() {
        int rowIndex = getTable().getSelectedRow();

        Preconditions.checkState(rowIndex != -1,
                                 "Cant remove caracteristic if no caracteristic selected");

        HydrologyRowModel row = getTableModel().getEntry(rowIndex);

        CaracteristicMap caracteristicMap = getModel().getCaracteristicMap();
        if (caracteristicMap != null) {
            caracteristicMap.remove(row.getKey());
        }

        //add the row in the combo
        BeanComboBox keyCombo = ui.getNewRowKey();
        keyCombo.addItem(row.getKey());
        selectFirstInCombo(keyCombo);

        // remove the row from the model
        getModel().getRows().remove(rowIndex);

        // refresh all the table
        getTableModel().fireTableRowsDeleted(rowIndex, rowIndex);

        getModel().removeRowInError(row);

//        Map<Type, Caracteristic> caracteristics = availableGlobalCaracteristics.get(row.getKey());
//        for (Type type : caracteristics.keySet()) {
//            Caracteristic caracteristic = caracteristics.get(type);
//
//            CaracteristicMap caracteristicMap = getModel().getCaracteristicMap();
//            if (caracteristicMap != null) {
//                caracteristicMap.remove(caracteristic);
//            }
//        }
//
//        //add the row in the combo
//        BeanComboBox keyCombo = ui.getNewRowKey();
//        keyCombo.addItem(row.getKey());
//        selectFirstInCombo(keyCombo);
//
//        // remove the row from the model
//        getModel().getRows().remove(rowIndex);
//
//        // refresh all the table
//        getTableModel().fireTableRowsDeleted(rowIndex, rowIndex);
//
//        getModel().removeRowInError(row);
    }

    //------------------------------------------------------------------------//
    //-- Protected methods                                                  --//
    //------------------------------------------------------------------------//

//    @Override
//    protected void saveRow(HydrologyRowModel row) {
//        if (row.isValid()) {
//            CaracteristicMap caracteristicMap = getModel().getCaracteristicMap();
//            Preconditions.checkNotNull(caracteristicMap);
//
//            Map<Type, Caracteristic> caracteristics = availableGlobalCaracteristics.get(row.getKey());
//            CaracteristicMap map = new CaracteristicMap();
//            for (Type type : caracteristics.keySet()) {
//                Serializable value = null;
//                switch (type) {
//                    case START:
//                        value = row.getGearShootingStartValue();
//                        break;
//                    case END:
//                        value = row.getGearShootingEndValue();
//                        break;
//                    case AVERAGE:
//                        value = row.getAverageValue();
//                }
//                map.put(caracteristics.get(type), value);
//            }
//            caracteristicMap.putAll(map);
//        }
//    }

}
