package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: SpeciesBatchTableModel.java 432 2013-02-15 20:28:55Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/SpeciesBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;

import javax.swing.table.TableColumnModel;
import java.util.Set;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class SpeciesBatchTableModel extends AbstractTuttiTableModel<SpeciesBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static class SampleColumnIdentifier<R> extends ColumnIdentifier<R> {

        private static final long serialVersionUID = 1L;

        public static <R> SampleColumnIdentifier<R> newId(String propertyName,
                                                          String weightPropertyName,
                                                          SampleCategoryType sampleCategoryType,
                                                          String headerI18nKey,
                                                          String headerTipI18nKey) {
            return new SampleColumnIdentifier<R>(propertyName,
                                                 weightPropertyName,
                                                 sampleCategoryType,
                                                 headerI18nKey,
                                                 headerTipI18nKey);
        }

        private final SampleCategoryType sampleCategoryType;

        private final String weightPropertyName;

        protected SampleColumnIdentifier(String propertyName,
                                         String weightPropertyName,
                                         SampleCategoryType sampleCategoryType,
                                         String headerI18nKey,
                                         String headerTipI18nKey
        ) {
            super(propertyName, headerI18nKey, headerTipI18nKey);
            this.weightPropertyName = weightPropertyName;
            this.sampleCategoryType = sampleCategoryType;
        }

        public void setWeightValue(R entry, Object value) {
            TuttiUIUtil.setProperty(entry, weightPropertyName, value);
        }

        public SampleCategoryType getSampleCategoryType() {
            return sampleCategoryType;
        }
    }

    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.table.species.batch.header.species"),
            n_("tutti.table.species.batch.header.species"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> SORTED_UNSORTED_CATEGORY = SampleColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SORTED_UNSORTED_CATEGORY,
            SpeciesBatchRowModel.PROPERTY_SORTED_UNSORTED_CATEGORY_WEIGHT,
            SampleCategoryType.sortedUnsorted,
            n_("tutti.table.species.batch.header.sortedUnsortedCategory"),
            n_("tutti.table.species.batch.header.sortedUnsortedCategory"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> SIZE_CATEGORY = SampleColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SIZE_CATEGORY,
            SpeciesBatchRowModel.PROPERTY_SIZE_CATEGORY_WEIGHT,
            SampleCategoryType.size,
            n_("tutti.table.species.batch.header.sizeCategory"),
            n_("tutti.table.species.batch.header.sizeCategory"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> SEX_CATEGORY = SampleColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SEX_CATEGORY,
            SpeciesBatchRowModel.PROPERTY_SEX_CATEGORY_WEIGHT,
            SampleCategoryType.sex,
            n_("tutti.table.species.batch.header.sexCategory"),
            n_("tutti.table.species.batch.header.sexCategory"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> MATURITY_CATEGORY = SampleColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_MATURITY_CATEGORY,
            SpeciesBatchRowModel.PROPERTY_MATURITY_CATEGORY_WEIGHT,
            SampleCategoryType.maturity,
            n_("tutti.table.species.batch.header.maturityCategory"),
            n_("tutti.table.species.batch.header.maturityCategory"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> AGE_CATEGORY = SampleColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_AGE_CATEGORY,
            SpeciesBatchRowModel.PROPERTY_AGE_CATEGORY_WEIGHT,
            SampleCategoryType.age,
            n_("tutti.table.species.batch.header.ageCategory"),
            n_("tutti.table.species.batch.header.ageCategory"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_COMPUTED_WEIGHT,
            n_("tutti.table.species.batch.header.weight"),
            n_("tutti.table.species.batch.header.weight"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> COMPUTED_NUMBER = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_COMPUTED_NUMBER,
            n_("tutti.table.species.batch.header.computedNumber"),
            n_("tutti.table.species.batch.header.computedNumber"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> COMMENT = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_COMMENT,
            n_("tutti.table.species.batch.header.comment"),
            n_("tutti.table.species.batch.header.comment"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> ATTACHMENTS = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_ATTACHMENTS,
            n_("tutti.table.species.batch.header.file"),
            n_("tutti.table.species.batch.header.file"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SPECIES_TO_CONFIRM,
            n_("tutti.table.species.batch.header.toConfirm"),
            n_("tutti.table.species.batch.header.toConfirm"));

    /**
     * Columns for the frequency edition.
     *
     * @since 0.2
     */
    protected final Set<ColumnIdentifier<SpeciesBatchRowModel>> frequencyCols;

    /**
     * Columns implies in the sample category definition.
     *
     * @since 0.2
     */
    protected final Set<ColumnIdentifier<SpeciesBatchRowModel>> sampleCols;

    /**
     * Mapping for each species of authroized sample category.
     *
     * @since 0.3
     */
    protected final Multimap<Species, SampleCategoryType> speciesSampleCategories;

    public SpeciesBatchTableModel(TableColumnModel columnModel,
                                  Multimap<Species, SampleCategoryType> speciesSampleCategories) {
        super(columnModel, false, false);
        this.speciesSampleCategories = speciesSampleCategories;
        setNoneEditableCols(SPECIES);

        frequencyCols = Sets.newHashSet();
        frequencyCols.add(COMPUTED_NUMBER);
        frequencyCols.add(WEIGHT);

        sampleCols = Sets.newHashSet();
        sampleCols.add(SORTED_UNSORTED_CATEGORY);
        sampleCols.add(SIZE_CATEGORY);
        sampleCols.add(SEX_CATEGORY);
        sampleCols.add(MATURITY_CATEGORY);
        sampleCols.add(AGE_CATEGORY);
    }

    @Override
    public SpeciesBatchRowModel createNewRow() {
        SpeciesBatchRowModel result = new SpeciesBatchRowModel();

        // by default empty row is not valid
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue,
                           int rowIndex,
                           int columnIndex,
                           ColumnIdentifier<SpeciesBatchRowModel> propertyName,
                           SpeciesBatchRowModel entry) {
        if (sampleCols.contains(propertyName)) {

            ((SampleColumnIdentifier<SpeciesBatchRowModel>) propertyName).setWeightValue(entry, aValue);
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
        }

//        if (propertyName == COMPUTED_NUMBER) {
//
//            // update also other columns
//            fireTableCellUpdated(rowIndex, COMPUTED_WEIGHT);
//
//        } else if (propertyName == COMPUTED_WEIGHT) {
//
//            // update also other columns
//            fireTableCellUpdated(rowIndex, COMPUTED_NUMBER);
//        }
    }

    public void updateSamplingRatio(Set<SpeciesBatchRowModel> rows) {
//        for (SpeciesBatchRowModel row : rows) {
//            int rowIndex = getRows().indexOf(row);
//            fireTableCellUpdated(rowIndex, SAMPLE_WEIGHT, SAMPLING_RATIO);
//        }
    }

    @Override
    protected boolean isCellEditable(int rowIndex,
                                     int columnIndex,
                                     ColumnIdentifier<SpeciesBatchRowModel> propertyName) {

        boolean result = super.isCellEditable(rowIndex,
                                              columnIndex,
                                              propertyName);
        if (result) {

            if (frequencyCols.contains(propertyName)) {

                // must have filled a species to edit this column
                SpeciesBatchRowModel entry = getEntry(rowIndex);
                result = entry.isValid() && entry.isBatchLeaf();

            } else if (sampleCols.contains(propertyName)) {

                SampleColumnIdentifier<SpeciesBatchRowModel> samplePropertyName = (SampleColumnIdentifier<SpeciesBatchRowModel>) propertyName;

                // can only edit if a category value is setted
                SpeciesBatchRowModel entry = getEntry(rowIndex);

                // check from protocol what is possible ?
                Species species = entry.getSpecies();

                if (species == null) {

                    // no species, can not edit
                    result = false;
                } else {

                    // Is protocol authorize it ?

                    result = speciesSampleCategories.containsEntry(
                            species,
                            samplePropertyName.getSampleCategoryType());

                    if (result) {

                        // protocol authorize it

                        // final test: can edit only if sample category is setted
                        SampleCategory<?> value =
                                (SampleCategory<?>) propertyName.getValue(entry);

                        result = value.getCategoryValue() != null;
                    }
                }
            }
        }
        return result;
    }
}
