package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCatchesUIHandler.java 432 2013-02-15 20:28:55Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/EditCatchesUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Sets;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIHandler;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.TabHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;

import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import java.awt.event.ActionEvent;
import java.util.Set;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class EditCatchesUIHandler extends AbstractTuttiTabContainerUIHandler<EditCatchesUIModel, EditCatchesUI>
        implements TabHandler {

    public static final String MAIN_CARD = "main";

    public static final String CREATE_BATCH_CARD = "createBatch";

    public static final String SPLIT_BATCH_CARD = "splitBatch";

    public static final String EDIT_FREQUENCY_CARD = "editFrequency";

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(EditCatchesUIHandler.class);

//    /**
//     * Persistence service.
//     *
//     * @since 0.3
//     */
//    private final PersistenceService persistenceService;

    /**
     * To monitor changes on the incoming fishing operation.
     *
     * @since 0.3
     */
    private final TuttiBeanMonitor<EditCatchesUIModel> catchBatchMonitor;

    protected final FishingOperationsUI parentUi;

    public EditCatchesUIHandler(FishingOperationsUI parentUi, EditCatchesUI ui) {
        super(parentUi.getHandler().getContext(), ui);
        this.parentUi = parentUi;
        this.catchBatchMonitor = new TuttiBeanMonitor<EditCatchesUIModel>(
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT);
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInitUI() {

        EditCatchesUIModel model = ui.getContextValue(EditCatchesUIModel.class);

        listModelIsModify(model);

        catchBatchMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        EditCatchesUIModel model = getModel();

        listenValidatorValid(getValidator(), model);

        setCustomTab(0, model);
    }

    @Override
    public void onCloseUI() {

        if (log.isInfoEnabled()) {
            log.info("closing: " + ui);
        }

        // close batches tabs, then general tab
        closeUI(ui.getSpeciesTabContent());
//        closeUI(ui.getBenthosTabContent());
//        closeUI(ui.getPlanktonTabContent());
//        closeUI(ui.getMacroWasteTabContent());
//        closeUI(ui.getAccidentalTabContent());
    }

    @Override
    public SwingValidator<EditCatchesUIModel> getValidator() {
        return ui.getValidator();
    }

    @Override
    protected Set<String> getPropertiesToIgnore() {
        Set<String> result = super.getPropertiesToIgnore();
        result.addAll(Sets.newHashSet(
                EditCatchesUIModel.PROPERTY_CATCH_TOTAL_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_CATCH_TOTAL_REJECTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SORTED_COMPUTED_WEIGHT
        ));
        return result;
    }

    @Override
    protected JTabbedPane getTabPanel() {
        return ui.getTabPane();
    }

    @Override
    public boolean onHideTab(int currentIndex, int newIndex) {
        //FIXME 20130203 kmorin: cannot change tab if model is modified 
        // (I do not even know why it is set to modified and have no time 
        // before the demo)
        EditCatchesUIModel model = getModel();
        boolean result;
        if (model.isModify()) {

            if (model.isValid()) {

                // ask user to save, do not save or cancel action
                int answer = askSaveBeforeLeaving(
                        _("tutti.dialog.askSaveBeforeLeaving.saveCatchBatch"));
                switch (answer) {
                    case JOptionPane.OK_OPTION:

                        // persist catch batch
                        doAction(getUI().getSaveButton(), null);

                        result = true;
                        break;

                    case JOptionPane.NO_OPTION:

                        // won't save modification
                        // so since we will edit a new operation, nothing to do here

                        // persist catch batch
                        doAction(getUI().getCancelButton(), null);

                        result = true;
                        break;
                    default:

                        // other case, use cancel action
                        result = false;
                }
            } else {

                // model is not valid, ask user to loose modification or cancel
                int answer = askCancelEditBeforeLeaving(
                        _("tutti.dialog.askCancelEditBeforeLeaving.cancelEditCatchBatch"));
                switch (answer) {
                    case JOptionPane.YES_OPTION:

                        // ok will revert any modification
                        ActionEvent event = new ActionEvent(this, newIndex, null);
                        doAction(ui.getCancelButton(), event);
                        result = true;
                        break;
                    default:

                        // other case, use cancel action
                        result = false;
                }
            }

        } else {

            // model not modify, can change tab
            result = true;
        }
        return result;
    }

    @Override
    public void onShowTab(int currentIndex, int newIndex) {
        registerValidators();
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public TuttiBeanMonitor<EditCatchesUIModel> getCatchBatchMonitor() {
        return catchBatchMonitor;
    }

    public FishingOperationsUI getParentUi() {
        return parentUi;
    }

    public FishingOperationsUIHandler getParentHandler() {
        return getParentUi().getHandler();
    }

    protected void registerValidators() {
        registerValidators(getValidator(), ui.getSpeciesTabContent().getHandler().getValidator());
    }

    public void setSpeciesSelectedCard(String card) {
        JPanel panel = ui.getSpeciesTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext) panel.getLayout();
        layout.setSelected(card);

        JPanel actionPanel = getUI().getCreateFishingOperationActions();
        if (MAIN_CARD.equals(card)) {
            registerValidators();
            actionPanel.setVisible(true);
        } else {
            actionPanel.setVisible(false);
            TuttiUI tuttiUi = null;
            JXTitledPanel titlePanel = null;
            String title = "";
            if (CREATE_BATCH_CARD.equals(card)) {
                tuttiUi = ui.getSpeciesTabCreateBatch();
                titlePanel = ui.getSpeciesTabCreateBatchReminderLabel();
                title = n_("tutti.title.createBatch");

            } else if (SPLIT_BATCH_CARD.equals(card)) {
                tuttiUi = ui.getSpeciesTabSplitBatch();
                titlePanel = ui.getSpeciesTabSplitBatchReminderLabel();
                title = n_("tutti.title.splitBatch");

            } else if (EDIT_FREQUENCY_CARD.equals(card)) {
                tuttiUi = ui.getSpeciesTabFrequencyEditor();
                titlePanel = ui.getSpeciesTabFrequencyEditorReminderLabel();
                title = n_("tutti.title.editFrequency");
            }

            if (tuttiUi != null) {
                registerValidators(tuttiUi.getHandler().getValidator());
            }
            if (titlePanel != null) {
                titlePanel.setTitle(ui.getSpeciesTabFishingOperationReminderLabel().getTitle() + " - " + _(title));
            }
        }

    }

}