/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.editor;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextEditorUI;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.swing.ComponentResizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class LongTextCellComponent
extends DefaultTableCellRenderer {
    private static final Log log = LogFactory.getLog(LongTextCellComponent.class);
    private static final long serialVersionUID = 1L;

    public LongTextCellComponent() {
        this.setHorizontalAlignment(0);
        this.setIcon(SwingUtil.createActionIcon((String)"edit-comment"));
    }

    @Override
    protected void setValue(Object value) {
    }

    public static TableCellRenderer newRender(String noneText) {
        return new LongTextCellRenderer(noneText);
    }

    public static TableCellEditor newEditor(LongTextEditorUI ui) {
        return new LongTextCellEditor(ui);
    }

    public static class LongTextCellRenderer
    implements TableCellRenderer {
        protected final LongTextCellComponent component = new LongTextCellComponent();
        protected String propertyName;
        public static final String TEXT_PATTERN = "<html><body>%s</body></html>";
        private final String noneText;

        public LongTextCellRenderer(String noneText) {
            this.noneText = noneText;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            LongTextCellComponent result = (LongTextCellComponent)this.component.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table != null) {
                String textValue;
                if (StringUtils.isBlank((CharSequence)((String)value))) {
                    if (this.propertyName == null) {
                        AbstractTuttiTableModel tableModel = (AbstractTuttiTableModel)table.getModel();
                        ColumnIdentifier columnIdentifier = tableModel.getPropertyName(column);
                        this.propertyName = columnIdentifier.getPropertyName();
                    }
                    textValue = "<i>" + I18n._((String)this.noneText, (Object[])new Object[0]) + "</i>";
                } else {
                    textValue = String.valueOf(value).replace("\n", "<br/>");
                }
                String text = String.format(TEXT_PATTERN, textValue);
                boolean editable = table.isCellEditable(row, column);
                result.setEnabled(editable);
                result.setToolTipText(text);
            }
            return result;
        }
    }

    public static class LongTextCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public static final int DEFAULT_EDITOR_WIDTH = 400;
        public static final int DEFAULT_EDITOR_HEIGHT = 200;
        private static final long serialVersionUID = 1L;
        protected final LongTextCellComponent component;
        protected final LongTextEditorUI ui;
        protected Frame frame;
        protected JTable table;
        protected AbstractTuttiTableModel<AbstractTuttiBeanUIModel> tableModel;
        protected ColumnIdentifier<AbstractTuttiBeanUIModel> columnIdentifier;
        protected AbstractTuttiBeanUIModel editRow;
        protected Integer rowIndex;
        protected Integer columnIndex;

        public LongTextCellEditor(LongTextEditorUI ui) {
            this.ui = ui;
            this.component = new LongTextCellComponent();
            this.component.setBorder(new LineBorder(Color.BLACK));
            this.component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        e.consume();
                        LongTextCellEditor.this.startEdit();
                    }
                }
            });
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                    LongTextCellEditor.this.startEdit();
                }
            });
        }

        protected void startEdit() {
            if (this.frame == null) {
                this.frame = (Frame)SwingUtil.getParentContainer((Object)((Object)this.ui), Frame.class);
            }
            this.ui.setBorder(BorderFactory.createTitledBorder(I18n._((String)this.columnIdentifier.getHeaderI18nKey(), (Object[])new Object[0])));
            this.ui.setBean((Object)this.editRow);
            this.ui.setProperty(this.columnIdentifier.getPropertyName());
            JDialog editor = new JDialog(this.frame, true);
            editor.setUndecorated(true);
            editor.add((Component)((Object)this.ui));
            editor.setSize(400, 200);
            editor.setResizable(true);
            ComponentResizer cr = new ComponentResizer();
            cr.registerComponent(new Component[]{editor});
            ComponentMover cm = new ComponentMover();
            cm.setDragInsets(cr.getDragInsets());
            cm.registerComponent(new Component[]{editor});
            editor.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Component ui = (Component)e.getSource();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Destroy ui " + ui));
                    }
                    JAXXUtil.destroy((Component)ui);
                }
            });
            int x = 0;
            int y = this.component.getHeight();
            for (Container comp = this.component; comp != null; comp = comp.getParent()) {
                x += ((Component)comp).getX();
                y += ((Component)comp).getY();
            }
            if (x + editor.getWidth() > this.frame.getX() + this.frame.getWidth()) {
                x = x - editor.getWidth() + this.component.getWidth();
            }
            editor.setLocation(x, y);
            editor.setVisible(true);
            int r = this.rowIndex;
            int c = this.columnIndex;
            this.stopCellEditing();
            AbstractSelectTableAction.doSelectCell(this.table, r, c);
            this.table.requestFocus();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.tableModel == null) {
                this.tableModel = (AbstractTuttiTableModel)table.getModel();
                this.table = table;
                this.columnIdentifier = this.tableModel.getPropertyName(column);
            }
            this.rowIndex = row;
            this.columnIndex = column;
            this.editRow = this.tableModel.getEntry(row);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            Preconditions.checkNotNull((Object)((Object)this.editRow), (Object)"No editRow found in editor.");
            String propertyName = this.columnIdentifier.getPropertyName();
            Object result = TuttiUIUtil.getProperty((Object)this.editRow, propertyName);
            if (log.isInfoEnabled()) {
                log.info((Object)("editor value (" + propertyName + "): " + result));
            }
            return result;
        }

        @Override
        public boolean stopCellEditing() {
            boolean b = super.stopCellEditing();
            if (b) {
                this.rowIndex = null;
                this.editRow = null;
                this.columnIndex = null;
            }
            return b;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.rowIndex = null;
            this.columnIndex = null;
            this.editRow = null;
        }
    }
}

