/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class AddSpeciesAction
extends AbstractTuttiAction<CreateSpeciesBatchUIModel, CreateSpeciesBatchUI, CreateSpeciesBatchUIHandler> {
    protected List<Species> allSpecies = this.getDataContext().getSpecies();
    protected List<Species> referentSpecies = this.getDataContext().getReferentSpecies();
    protected Species selectedSpecies;

    public AddSpeciesAction(CreateSpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean canContinue = super.prepareAction();
        if (canContinue) {
            CreateSpeciesBatchUIModel model = (CreateSpeciesBatchUIModel)((Object)this.getModel());
            ArrayList species = Lists.newArrayList(this.allSpecies);
            species.removeAll(model.getAvailableSpecies());
            this.selectedSpecies = ((CreateSpeciesBatchUIHandler)this.getHandler()).openAddSpeciesDialog(I18n._((String)"tutti.title.selectSpecies", (Object[])new Object[0]), species);
            canContinue = this.selectedSpecies != null;
        }
        return canContinue;
    }

    @Override
    protected void doAction() throws Exception {
        CreateSpeciesBatchUIModel model = (CreateSpeciesBatchUIModel)((Object)this.getModel());
        ArrayList availableSpecies = Lists.newArrayList(model.getAvailableSpecies());
        if (!this.selectedSpecies.isReferenceTaxon()) {
            String decoratedSynonym = this.decorate(this.selectedSpecies);
            List<Species> referents = this.referentSpecies;
            Map referentsById = TuttiEntities.splitByTaxonId(referents);
            String taxonId = String.valueOf(this.selectedSpecies.getReferenceTaxonId());
            this.selectedSpecies = (Species)referentsById.get(taxonId);
            String decoratedReferent = this.decorate(this.selectedSpecies);
            this.sendMessage(I18n._((String)"tutti.flash.information.species.replaced", (Object[])new Object[]{decoratedSynonym, decoratedReferent}));
        }
        if (!availableSpecies.contains(this.selectedSpecies)) {
            availableSpecies.add(this.selectedSpecies);
        }
        model.setAvailableSpecies(availableSpecies);
        model.setSpecies(this.selectedSpecies);
    }
}

