/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractSerializableBean;

public class FishingOperationsUIModel
extends AbstractSerializableBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FishingOperationsUIModel.class);
    public static final String PROPERTY_FISHING_OPERATION = "fishingOperation";
    public static final String PROPERTY_SELECTED_FISHING_OPERATION = "selectedFishingOperation";
    public static final String PROPERTY_EDITED_FISHING_OPERATION = "editedFishingOperation";
    protected List<FishingOperation> fishingOperation;
    protected FishingOperation selectedFishingOperation;
    protected FishingOperation editFishingOperation;
    protected boolean selectionAdjusting;
    protected boolean editionAdjusting;

    public List<FishingOperation> getFishingOperation() {
        return this.fishingOperation;
    }

    public void setFishingOperation(List<FishingOperation> fishingOperation) {
        List<FishingOperation> oldValue = this.getFishingOperation();
        this.fishingOperation = fishingOperation;
        this.firePropertyChange(PROPERTY_FISHING_OPERATION, oldValue, fishingOperation);
    }

    public void addFishingOperation(FishingOperation fishingOperation) {
        ArrayList oldValue = Lists.newArrayList(this.getFishingOperation());
        this.fishingOperation.add(fishingOperation);
        this.firePropertyChange(PROPERTY_FISHING_OPERATION, oldValue, this.fishingOperation);
    }

    public void removeFishingOperation(FishingOperation fishingOperation) {
        ArrayList oldValue = Lists.newArrayList(this.getFishingOperation());
        this.fishingOperation.remove(fishingOperation);
        this.firePropertyChange(PROPERTY_FISHING_OPERATION, oldValue, this.fishingOperation);
    }

    public void updateFishingOperation(FishingOperation newFishingOperation) {
        Preconditions.checkNotNull((Object)newFishingOperation);
        String id = newFishingOperation.getId();
        Preconditions.checkNotNull((Object)id);
        FishingOperation oldFishingOperation = this.getFishingOperation(id);
        Preconditions.checkNotNull((Object)oldFishingOperation);
        if (log.isInfoEnabled()) {
            log.info((Object)("Update existing fishing operation: " + id));
        }
        int oldFishingOperationIndex = this.fishingOperation.indexOf(oldFishingOperation);
        this.fishingOperation.remove(oldFishingOperation);
        this.fishingOperation.add(oldFishingOperationIndex, newFishingOperation);
        this.firePropertyChange(PROPERTY_FISHING_OPERATION, null, this.fishingOperation);
    }

    public FishingOperation getSelectedFishingOperation() {
        return this.selectedFishingOperation;
    }

    public void setSelectedFishingOperation(FishingOperation selectedFishingOperation) {
        FishingOperation oldValue = this.getSelectedFishingOperation();
        this.selectedFishingOperation = selectedFishingOperation;
        if (!this.isSelectionAdjusting()) {
            this.firePropertyChange(PROPERTY_SELECTED_FISHING_OPERATION, oldValue, selectedFishingOperation);
        }
    }

    public FishingOperation getEditFishingOperation() {
        return this.editFishingOperation;
    }

    public void setEditFishingOperation(FishingOperation editFishingOperation) {
        FishingOperation oldValue = this.getEditFishingOperation();
        this.editFishingOperation = editFishingOperation;
        if (!this.isEditionAdjusting()) {
            this.firePropertyChange(PROPERTY_EDITED_FISHING_OPERATION, oldValue, editFishingOperation);
        }
    }

    public boolean isSelectionAdjusting() {
        return this.selectionAdjusting;
    }

    public void setSelectionAdjusting(boolean selectionAdjusting) {
        this.selectionAdjusting = selectionAdjusting;
    }

    public boolean isEditionAdjusting() {
        return this.editionAdjusting;
    }

    public void setEditionAdjusting(boolean editionAdjusting) {
        this.editionAdjusting = editionAdjusting;
    }

    public FishingOperation getFishingOperation(String id) {
        FishingOperation result = (FishingOperation)TuttiEntities.findById(this.fishingOperation, (String)id);
        return result;
    }
}

