/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao;

import fr.ifremer.adagio.core.dao.CriteriaSearchConfiguration;
import fr.ifremer.adagio.core.dao.CriteriaSearchParameter;
import fr.ifremer.adagio.core.dao.CriteriaSearchProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class CriteriaSearch {
    private CriteriaSearchConfiguration configuration = new CriteriaSearchConfiguration();
    private Criteria rootCriteria;
    private Map childCriteriaMap;
    private List orderList;
    private Class resultType;

    protected Criteria getRootCriteria() {
        return this.rootCriteria;
    }

    public CriteriaSearch(Session session, Class resultType) {
        this.resultType = resultType;
        this.rootCriteria = session.createCriteria(this.resultType);
        this.childCriteriaMap = new HashMap();
        this.orderList = new ArrayList();
    }

    public Set executeAsSet() throws HibernateException {
        return new LinkedHashSet(this.executeAsList());
    }

    public List executeAsList() throws HibernateException {
        if (this.orderList.size() > 0) {
            Collections.sort(this.orderList, new ParameterComparator());
            for (CriteriaSearchParameter parameter : this.orderList) {
                int direction = parameter.getOrderDirection();
                if (direction == 0) {
                    this.getParameterCriteria(parameter).addOrder(Order.asc((String)this.getParameterName(parameter)));
                    continue;
                }
                this.getParameterCriteria(parameter).addOrder(Order.desc((String)this.getParameterName(parameter)));
            }
        }
        if (this.configuration.getFirstResult() != null) {
            this.rootCriteria.setFirstResult(this.configuration.getFirstResult().intValue());
        }
        if (this.configuration.getFetchSize() != null) {
            this.rootCriteria.setFetchSize(this.configuration.getFetchSize().intValue());
        }
        if (this.configuration.getMaximumResultSize() != null) {
            this.rootCriteria.setMaxResults(this.configuration.getMaximumResultSize().intValue());
        }
        this.rootCriteria.setCacheable(true);
        return this.rootCriteria.list();
    }

    public void addParameter(Object parameterValue, String parameterPattern) throws HibernateException {
        this.addParameter(new CriteriaSearchParameter(parameterValue, parameterPattern));
    }

    public void addParameter(String parameterValue, String parameterPattern) throws HibernateException {
        this.addParameter(new CriteriaSearchParameter(parameterValue, parameterPattern));
    }

    public void addParameter(CriteriaSearchParameter parameter) throws HibernateException {
        if (this.considerParameter(parameter)) {
            Criteria parameterCriteria = this.getParameterCriteria(parameter);
            String parameterName = this.getParameterName(parameter);
            if (parameter.getParameterValue() instanceof Object[]) {
                this.addExpression(parameterCriteria, parameterName, (Object[])parameter.getParameterValue(), parameter.getComparator(), parameter.getMatchMode());
            } else {
                this.addExpression(parameterCriteria, parameterName, parameter.getParameterValue(), parameter.getComparator(), parameter.getMatchMode());
            }
        }
        if (parameter.getOrderDirection() != -1) {
            this.orderList.add(parameter);
        }
    }

    private Criteria getParameterCriteria(CriteriaSearchParameter parameter) throws HibernateException {
        String[] pathBeforeProcessing = CriteriaSearchParameter.PATTERN.split(parameter.getParameterPattern());
        Criteria parameterCriteria = this.rootCriteria;
        if (pathBeforeProcessing.length > 1) {
            ArrayList<String> pathProcessing = new ArrayList<String>();
            for (int i = 0; i < pathBeforeProcessing.length; ++i) {
                String processing = pathBeforeProcessing[i];
                if (processing.endsWith("Pk")) {
                    StringBuffer buffer = new StringBuffer(processing);
                    if (++i < pathBeforeProcessing.length) {
                        buffer.append(".");
                        buffer.append(pathBeforeProcessing[i]);
                    }
                    pathProcessing.add(buffer.toString());
                    continue;
                }
                pathProcessing.add(processing);
            }
            String[] path = pathProcessing.toArray(new String[0]);
            if (path.length > 1) {
                Criteria childEntityCriteria = this.rootCriteria;
                Class type = this.resultType;
                for (int index = 0; index < path.length - 1; ++index) {
                    String childEntityName = path[index];
                    Collection embeddedValues = CriteriaSearchProperties.getEmbeddedValues(type);
                    if (embeddedValues != null && embeddedValues.contains(childEntityName)) {
                        int number = path.length - index;
                        String[] restOfPath = new String[path.length - index];
                        System.arraycopy(path, index, restOfPath, 0, number);
                        break;
                    }
                    type = CriteriaSearchProperties.getNavigableAssociationEndType(type, childEntityName);
                    childEntityCriteria = this.locateCriteria(childEntityName, childEntityCriteria);
                }
                if (childEntityCriteria != null) {
                    parameterCriteria = childEntityCriteria;
                }
            }
        }
        return parameterCriteria;
    }

    private String getParameterName(CriteriaSearchParameter parameter) {
        String[] pathBeforeProcessing = CriteriaSearchParameter.PATTERN.split(parameter.getParameterPattern());
        ArrayList<String> pathProcessing = new ArrayList<String>();
        for (int i = 0; i < pathBeforeProcessing.length; ++i) {
            String processing = pathBeforeProcessing[i];
            if (processing.endsWith("Pk")) {
                StringBuffer buffer = new StringBuffer(processing);
                if (++i < pathBeforeProcessing.length) {
                    buffer.append(".");
                    buffer.append(pathBeforeProcessing[i]);
                }
                pathProcessing.add(buffer.toString());
                continue;
            }
            pathProcessing.add(processing);
        }
        String[] path = pathProcessing.toArray(new String[0]);
        String parameterName = path[path.length - 1];
        if (path.length > 1) {
            Class type = this.resultType;
            for (int index = 0; index < path.length - 1; ++index) {
                String childEntityName = path[index];
                Collection embeddedValues = CriteriaSearchProperties.getEmbeddedValues(type);
                if (embeddedValues != null && embeddedValues.contains(childEntityName)) {
                    int number = path.length - index;
                    Object[] restOfPath = new String[path.length - index];
                    System.arraycopy(path, index, restOfPath, 0, number);
                    parameterName = StringUtils.join((Object[])restOfPath, (String)".");
                    break;
                }
                type = CriteriaSearchProperties.getNavigableAssociationEndType(type, childEntityName);
            }
        }
        return parameterName;
    }

    private boolean considerParameter(CriteriaSearchParameter parameter) {
        if (parameter.getParameterValue() instanceof String) {
            String stringParameterValue = (String)parameter.getParameterValue();
            return parameter.isSearchIfNull() || stringParameterValue != null && stringParameterValue.length() > 0;
        }
        if (parameter.getParameterValue() instanceof Object[]) {
            Object[] parameterValues = (Object[])parameter.getParameterValue();
            return parameter.isSearchIfNull() || parameterValues != null && parameterValues.length > 0;
        }
        int comparator = parameter.getComparator();
        return parameter.isSearchIfNull() || 9 == comparator || 10 == comparator || parameter.getParameterValue() != null;
    }

    private void addExpression(Criteria criteria, String parameterName, Object parameterValue, int comparator, MatchMode matchMode) {
        switch (comparator) {
            case 9: {
                criteria.add(Expression.isNotNull((String)parameterName));
                break;
            }
            case 10: {
                criteria.add(Expression.isNull((String)parameterName));
                break;
            }
            default: {
                if (parameterValue != null) {
                    switch (comparator) {
                        case 0: {
                            if (matchMode != null && parameterValue instanceof String) {
                                criteria.add((Criterion)Expression.like((String)parameterName, (String)((String)parameterValue), (MatchMode)matchMode));
                                break;
                            }
                            criteria.add((Criterion)Expression.like((String)parameterName, (Object)parameterValue));
                            break;
                        }
                        case 1: {
                            if (matchMode != null && parameterValue instanceof String) {
                                criteria.add(Expression.ilike((String)parameterName, (String)((String)parameterValue), (MatchMode)matchMode));
                                break;
                            }
                            criteria.add(Expression.ilike((String)parameterName, (Object)parameterValue));
                            break;
                        }
                        case 2: {
                            criteria.add((Criterion)Expression.eq((String)parameterName, (Object)parameterValue));
                            break;
                        }
                        case 3: {
                            criteria.add((Criterion)Expression.ge((String)parameterName, (Object)parameterValue));
                            break;
                        }
                        case 4: {
                            criteria.add((Criterion)Expression.gt((String)parameterName, (Object)parameterValue));
                            break;
                        }
                        case 5: {
                            criteria.add((Criterion)Expression.le((String)parameterName, (Object)parameterValue));
                            break;
                        }
                        case 6: {
                            criteria.add((Criterion)Expression.lt((String)parameterName, (Object)parameterValue));
                            break;
                        }
                        case 7: {
                            if (!(parameterValue instanceof Collection)) break;
                            criteria.add(Expression.in((String)parameterName, (Collection)((Collection)parameterValue)));
                            break;
                        }
                        case 11: {
                            if (!(parameterValue instanceof Collection)) break;
                            criteria.add(Expression.not((Criterion)Expression.in((String)parameterName, (Collection)((Collection)parameterValue))));
                            break;
                        }
                        case 8: {
                            criteria.add((Criterion)Expression.ne((String)parameterName, (Object)parameterValue));
                            break;
                        }
                        case 12: {
                            if (matchMode != null && parameterValue instanceof String) {
                                criteria.add(Expression.not((Criterion)Expression.like((String)parameterName, (String)((String)parameterValue), (MatchMode)matchMode)));
                                break;
                            }
                            criteria.add(Expression.not((Criterion)Expression.like((String)parameterName, (Object)parameterValue)));
                            break;
                        }
                        case 13: {
                            if (matchMode != null && parameterValue instanceof String) {
                                criteria.add(Expression.not((Criterion)Expression.ilike((String)parameterName, (String)((String)parameterValue), (MatchMode)matchMode)));
                                break;
                            }
                            criteria.add(Expression.not((Criterion)Expression.ilike((String)parameterName, (Object)parameterValue)));
                        }
                    }
                    break;
                }
                criteria.add(Expression.isNull((String)parameterName));
            }
        }
    }

    private void addExpression(Criteria criteria, String parameterName, Object[] parameterValues, int comparator, MatchMode matchMode) {
        if (parameterValues != null) {
            Disjunction disjunction = null;
            Conjunction conjunction = null;
            switch (comparator) {
                case 0: {
                    disjunction = Restrictions.disjunction();
                    if (matchMode != null && parameterValues instanceof String[]) {
                        String[] stringParameterValues = (String[])parameterValues;
                        for (int index = 0; index < parameterValues.length; ++index) {
                            if (stringParameterValues[index] != null) {
                                disjunction.add((Criterion)Expression.like((String)parameterName, (String)stringParameterValues[index], (MatchMode)matchMode));
                                continue;
                            }
                            disjunction.add(Expression.isNull((String)parameterName));
                        }
                    } else {
                        for (int index = 0; index < parameterValues.length; ++index) {
                            if (parameterValues[index] != null) {
                                disjunction.add((Criterion)Expression.like((String)parameterName, (Object)parameterValues[index]));
                                continue;
                            }
                            disjunction.add(Expression.isNull((String)parameterName));
                        }
                    }
                    break;
                }
                case 1: {
                    disjunction = Restrictions.disjunction();
                    if (matchMode != null && parameterValues instanceof String[]) {
                        String[] stringParameterValues = (String[])parameterValues;
                        for (int index = 0; index < parameterValues.length; ++index) {
                            if (stringParameterValues[index] != null) {
                                disjunction.add(Expression.ilike((String)parameterName, (String)stringParameterValues[index], (MatchMode)matchMode));
                                continue;
                            }
                            disjunction.add(Expression.isNull((String)parameterName));
                        }
                    } else {
                        for (int index = 0; index < parameterValues.length; ++index) {
                            if (parameterValues[index] != null) {
                                disjunction.add(Expression.ilike((String)parameterName, (Object)parameterValues[index]));
                                continue;
                            }
                            disjunction.add(Expression.isNull((String)parameterName));
                        }
                    }
                    break;
                }
                case 2: {
                    disjunction = Restrictions.disjunction();
                    for (int index = 0; index < parameterValues.length; ++index) {
                        if (parameterValues[index] != null) {
                            disjunction.add((Criterion)Expression.eq((String)parameterName, (Object)parameterValues[index]));
                            continue;
                        }
                        disjunction.add(Expression.isNull((String)parameterName));
                    }
                    break;
                }
                case 3: {
                    disjunction = Restrictions.disjunction();
                    for (int index = 0; index < parameterValues.length; ++index) {
                        if (parameterValues[index] != null) {
                            disjunction.add((Criterion)Expression.ge((String)parameterName, (Object)parameterValues[index]));
                            continue;
                        }
                        disjunction.add(Expression.isNull((String)parameterName));
                    }
                    break;
                }
                case 4: {
                    disjunction = Restrictions.disjunction();
                    for (int index = 0; index < parameterValues.length; ++index) {
                        if (parameterValues[index] != null) {
                            disjunction.add((Criterion)Expression.gt((String)parameterName, (Object)parameterValues[index]));
                            continue;
                        }
                        disjunction.add(Expression.isNull((String)parameterName));
                    }
                    break;
                }
                case 5: {
                    disjunction = Restrictions.disjunction();
                    for (int index = 0; index < parameterValues.length; ++index) {
                        if (parameterValues[index] != null) {
                            disjunction.add((Criterion)Expression.le((String)parameterName, (Object)parameterValues[index]));
                            continue;
                        }
                        disjunction.add(Expression.isNull((String)parameterName));
                    }
                    break;
                }
                case 6: {
                    disjunction = Restrictions.disjunction();
                    for (int index = 0; index < parameterValues.length; ++index) {
                        if (parameterValues[index] != null) {
                            disjunction.add((Criterion)Expression.lt((String)parameterName, (Object)parameterValues[index]));
                            continue;
                        }
                        disjunction.add(Expression.isNull((String)parameterName));
                    }
                    break;
                }
                case 7: {
                    criteria.add(Expression.in((String)parameterName, (Object[])parameterValues));
                    break;
                }
                case 11: {
                    criteria.add(Expression.not((Criterion)Expression.in((String)parameterName, (Object[])parameterValues)));
                    break;
                }
                case 8: {
                    conjunction = Restrictions.conjunction();
                    for (int index = 0; index < parameterValues.length; ++index) {
                        if (parameterValues[index] != null) {
                            conjunction.add((Criterion)Expression.ne((String)parameterName, (Object)parameterValues[index]));
                            continue;
                        }
                        conjunction.add(Expression.isNotNull((String)parameterName));
                    }
                    break;
                }
                case 12: {
                    conjunction = Restrictions.conjunction();
                    if (matchMode == null || !(parameterValues instanceof String[])) break;
                    String[] stringParameterValues = (String[])parameterValues;
                    for (int index = 0; index < stringParameterValues.length; ++index) {
                        if (stringParameterValues[index] != null) {
                            conjunction.add(Expression.not((Criterion)Expression.like((String)parameterName, (String)stringParameterValues[index], (MatchMode)matchMode)));
                            continue;
                        }
                        conjunction.add(Expression.isNotNull((String)parameterName));
                    }
                    break;
                }
                case 13: {
                    conjunction = Restrictions.conjunction();
                    if (matchMode == null || !(parameterValues instanceof String[])) break;
                    String[] stringParameterValues = (String[])parameterValues;
                    for (int index = 0; index < stringParameterValues.length; ++index) {
                        if (stringParameterValues[index] != null) {
                            conjunction.add(Expression.not((Criterion)Expression.ilike((String)parameterName, (String)stringParameterValues[index], (MatchMode)matchMode)));
                            continue;
                        }
                        conjunction.add(Expression.isNotNull((String)parameterName));
                    }
                    break;
                }
            }
            if (disjunction != null) {
                criteria.add((Criterion)disjunction);
            }
            if (conjunction != null) {
                criteria.add((Criterion)conjunction);
            }
        } else {
            criteria.add(Expression.isNull((String)parameterName));
        }
    }

    private Criteria locateCriteria(String childEntityName, Criteria parentCriteria) throws HibernateException {
        if (this.childCriteriaMap.containsKey(childEntityName)) {
            return (Criteria)this.childCriteriaMap.get(childEntityName);
        }
        Criteria childCriteria = parentCriteria.createCriteria(childEntityName);
        if (this.configuration.isForceEagerLoading()) {
            parentCriteria.setFetchMode(childEntityName, FetchMode.JOIN);
        }
        parentCriteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        this.childCriteriaMap.put(childEntityName, childCriteria);
        return childCriteria;
    }

    public CriteriaSearchConfiguration getConfiguration() {
        return this.configuration;
    }

    private static final class ParameterComparator
    implements Comparator {
        private ParameterComparator() {
        }

        public int compare(Object object1, Object object2) {
            CriteriaSearchParameter parameter1 = (CriteriaSearchParameter)object1;
            CriteriaSearchParameter parameter2 = (CriteriaSearchParameter)object2;
            int relevance1 = parameter1.getOrderRelevance();
            int relevance2 = parameter2.getOrderRelevance();
            int result = 0;
            if (relevance1 > relevance2) {
                result = 1;
            } else if (relevance1 < relevance2) {
                result = -1;
            }
            return result;
        }
    }
}

