/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SaveProtocolAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(SaveProtocolAction.class);

    public SaveProtocolAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected void doAction() throws Exception {
        TuttiProtocol saved;
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        TuttiUIContext context = this.getContext();
        PersistenceService persistenceService = context.getPersistenceService();
        TuttiProtocol bean = (TuttiProtocol)model.toBean();
        ArrayList protocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getRows()) {
            if (!row.isValid()) continue;
            SpeciesProtocol protocol = (SpeciesProtocol)row.toBean();
            protocols.add(protocol);
        }
        bean.setSpecies(protocols);
        if (log.isDebugEnabled()) {
            log.debug((Object)("protocol id to save: " + bean.getId()));
        }
        if (TuttiEntities.isNew(bean)) {
            saved = persistenceService.createProtocol(bean);
            model.setId(saved.getId());
            this.sendMessage(I18n._((String)"tutti.flash.information.protocolCreated", (Object[])new Object[]{bean.getName()}));
        } else {
            saved = persistenceService.saveProtocol(bean);
            this.sendMessage(I18n._((String)"tutti.flash.information.protocolSaved", (Object[])new Object[]{bean.getName()}));
        }
        context.setProtocolId(saved.getId());
        model.setModify(false);
    }

    @Override
    public void postSuccessAction() {
        this.getContext().getMainUI().getHandler().setBodyTitle(EditProtocolUIHandler.getTitle(true));
    }
}

