/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.config;

import fr.ifremer.tutti.service.config.TuttiServiceConfigOption;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfigOption;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.ReloadTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiUIAction;
import fr.ifremer.tutti.ui.swing.util.editor.VesselTableCell;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.Icon;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.config.ConfigUI;
import jaxx.runtime.swing.config.ConfigUIHelper;
import jaxx.runtime.swing.config.model.CallBackFinalizer;
import jaxx.runtime.swing.config.model.MainCallBackFinalizer;
import org.nuiton.i18n.I18n;
import org.nuiton.util.config.ConfigOptionDef;

public class TuttiConfigUI {
    public static final String CALLBACK_APPLICATION = "application";
    public static final String CALLBACK_UI = "ui";
    public static final String CALLBACK_SHORTCUT = "shortcut";
    protected final MainUI mainUI;

    public TuttiConfigUI(MainUI mainUI) {
        this.mainUI = mainUI;
    }

    public void createUI() {
        TuttiApplicationConfig config = this.mainUI.getHandler().getContext().getConfig();
        ConfigUIHelper helper = new ConfigUIHelper(config.getApplicationConfig());
        helper.registerCallBack(CALLBACK_UI, I18n.n_((String)"tutti.action.reload.ui", (Object[])new Object[0]), (Icon)SwingUtil.createActionIcon((String)"reload-ui"), new Runnable(){

            @Override
            public void run() {
                TuttiConfigUI.this.reloadUI();
            }
        }).registerCallBack(CALLBACK_APPLICATION, I18n.n_((String)"tutti.action.reload.application", (Object[])new Object[0]), (Icon)SwingUtil.createActionIcon((String)"reload-application"), new Runnable(){

            @Override
            public void run() {
                TuttiConfigUI.this.reloadApplication();
            }
        }).registerCallBack(CALLBACK_SHORTCUT, I18n.n_((String)"tutti.action.reload.actions", (Object[])new Object[0]), (Icon)SwingUtil.createActionIcon((String)"reload-shortcut"), new Runnable(){

            @Override
            public void run() {
                TuttiConfigUI.this.reloadShortcuts();
            }
        });
        helper.addCategory(I18n.n_((String)"tutti.config.category.applications", (Object[])new Object[0]), I18n.n_((String)"tutti.config.category.applications.description", (Object[])new Object[0]), CALLBACK_APPLICATION).addOption((ConfigOptionDef)TuttiServiceConfigOption.DATA_DIRECTORY).addOption((ConfigOptionDef)TuttiServiceConfigOption.SITE_URL).addOption((ConfigOptionDef)TuttiApplicationConfigOption.UI_CONFIG_FILE).addOption((ConfigOptionDef)TuttiApplicationConfigOption.TOTAL_SORTED_WEIGHTS_DIFFERENCE_RATE);
        TuttiUIContext context = this.mainUI.getHandler().getContext();
        if (context.isDbLoaded()) {
            VesselTableCell vesselTableCellComponent = new VesselTableCell(context);
            helper.addOption((ConfigOptionDef)TuttiApplicationConfigOption.TREMIE_CAROUSSEL_VESSEL_ID).setOptionEditor(vesselTableCellComponent.getNewTableCellEditor()).setOptionRenderer(vesselTableCellComponent.getNewTableCellRenderer());
        }
        helper.addCategory(I18n.n_((String)"tutti.config.category.ui", (Object[])new Object[0]), I18n.n_((String)"tutti.config.category.ui.description", (Object[])new Object[0]), CALLBACK_UI).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COLOR_ROW_INVALID).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COLOR_ROW_READ_ONLY).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COLOR_CELL_WITH_VALUE).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COLOR_ROW_TO_CONFIRM).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COLOR_COMPUTED_WEIGHTS).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COLOR_BLOCKING_LAYER).addOption((ConfigOptionDef)TuttiApplicationConfigOption.DATE_FORMAT).addOption((ConfigOptionDef)TuttiApplicationConfigOption.COORDINATE_EDITOR_TYPE);
        helper.addCategory(I18n.n_((String)"tutti.config.category.shortcuts", (Object[])new Object[0]), I18n.n_((String)"tutti.config.category.shortcuts.description", (Object[])new Object[0]), CALLBACK_SHORTCUT).addOption((ConfigOptionDef)TuttiApplicationConfigOption.SHORTCUT_CLOSE_POPUP);
        helper.setFinalizer((CallBackFinalizer)new MainCallBackFinalizer(CALLBACK_APPLICATION));
        ConfigUI configUI = helper.buildUI((JAXXContext)this.mainUI, I18n.n_((String)"tutti.config.category.applications", (Object[])new Object[0]));
        helper.displayUI((Frame)this.mainUI, false);
        this.mainUI.getHandler().getContext().getSwingSession().add((Component)configUI);
    }

    protected void reloadApplication() {
        MainUIHandler handler = this.mainUI.getHandler();
        TuttiUIAction<ReloadTuttiAction> action = handler.createUIAction(null, ReloadTuttiAction.class);
        action.actionPerformed(null);
    }

    protected void reloadUI() {
        this.mainUI.getHandler().reloadUI();
    }

    protected void reloadShortcuts() {
        this.mainUI.getHandler().reloadUI();
    }
}

