/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportAllCaracteristicAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ExportAllCaracteristicAction.class);
    private File file;

    public ExportAllCaracteristicAction(EditProtocolUIHandler handler) {
        super(handler, "exportAllCaracteristic", "export", I18n._((String)"tutti.action.exportAllCaracteristic", (Object[])new Object[0]), I18n._((String)"tutti.action.exportAllCaracteristic.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean doAction;
        this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.protocolCaracteristicExportFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseProtocolCaracteristicFile", (Object[])new Object[0]), null, "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
        boolean bl = doAction = this.file != null;
        if (doAction) {
            super.prepareAction(event);
        }
        return doAction;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        this.file = null;
    }

    @Override
    protected void doAction(ActionEvent e) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export all caracteristic to file: " + this.file));
        }
        TuttiProtocolImportExportService service = this.getService(TuttiProtocolImportExportService.class);
        service.exportAllCaracteristic(this.file, ((EditProtocolUIModel)((Object)this.getModel())).getAllCaracteristic());
        this.sendMessage(I18n._((String)"tutti.flash.information.all.caractristic.exported", (Object[])new Object[]{this.file}));
    }
}

