/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUIModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class AddSpeciesAction
extends AbstractTuttiAction<CreateSpeciesBatchUIModel, CreateSpeciesBatchUI, CreateSpeciesBatchUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AddSpeciesAction.class);
    protected List<Species> allSpecies;
    protected List<Species> referentSpecies;
    protected Species selectedSpecies;

    public AddSpeciesAction(CreateSpeciesBatchUIHandler handler) {
        super(handler, "addSpecies", null, I18n._((String)"tutti.action.addSpecies.text", (Object[])new Object[0]), I18n._((String)"tutti.action.addSpecies.tip", (Object[])new Object[0]), false);
        TuttiPersistence persistenceService = (TuttiPersistence)this.getContext().getService(PersistenceService.class);
        this.allSpecies = persistenceService.getAllSpecies();
        this.referentSpecies = persistenceService.getAllReferentSpecies();
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean result = super.prepareAction(event);
        List<Species> availableSpecies = ((CreateSpeciesBatchUIModel)((Object)this.getModel())).getAvailableSpecies();
        ArrayList species = Lists.newArrayList(this.allSpecies);
        species.removeAll(availableSpecies);
        this.selectedSpecies = ((CreateSpeciesBatchUIHandler)this.getHandler()).openAddSpeciesDialog(I18n._((String)"tutti.title.selectSpecies", (Object[])new Object[0]), species);
        return result &= this.selectedSpecies != null;
    }

    @Override
    protected void doAction(ActionEvent event) {
        ArrayList availableSpecies;
        CreateSpeciesBatchUIModel model = (CreateSpeciesBatchUIModel)((Object)this.getModel());
        if (!this.selectedSpecies.isReferenceTaxon()) {
            String decoratedSynonym = this.decorate(this.selectedSpecies);
            List<Species> referents = this.referentSpecies;
            Map referentsById = TuttiEntities.splitByTaxonId(referents);
            String taxonId = String.valueOf(this.selectedSpecies.getReferenceTaxonId());
            this.selectedSpecies = (Species)referentsById.get(taxonId);
            String decoratedReferent = this.decorate(this.selectedSpecies);
            this.sendMessage(I18n._((String)"tutti.flash.information.species.replaced", (Object[])new Object[]{decoratedSynonym, decoratedReferent}));
        }
        if (!(availableSpecies = Lists.newArrayList(model.getAvailableSpecies())).contains(this.selectedSpecies)) {
            availableSpecies.add(this.selectedSpecies);
        }
        model.setAvailableSpecies(availableSpecies);
        model.setSpecies(this.selectedSpecies);
    }
}

