/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.CaracteristicTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.TabHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JTabbedPane;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditFishingOperationUIHandler
extends AbstractTuttiTabContainerUIHandler<EditFishingOperationUIModel, EditFishingOperationUI>
implements TabHandler {
    private static final Log log = LogFactory.getLog(EditFishingOperationUIHandler.class);
    private final FishingOperationsUI parentUi;
    private final PersistenceService persistenceService;
    private final PropertyChangeListener startDateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Date oldDate = (Date)evt.getOldValue();
            Date newDate = (Date)evt.getNewValue();
            if (!(((EditFishingOperationUIModel)((Object)EditFishingOperationUIHandler.this.getModel())).getGearShootingEndDate() != null || oldDate != null && DateUtils.isSameDay((Date)oldDate, (Date)newDate))) {
                ((EditFishingOperationUIModel)((Object)EditFishingOperationUIHandler.this.getModel())).setGearShootingEndDate(newDate);
            }
        }
    };
    private final PropertyChangeListener coordinatePropertiesListener = new PropertyChangeListener(){
        private List<String> properties = Lists.newArrayList((Object[])new String[]{"fishingOperationRectiligne", "gearShootingEndLatitude", "gearShootingEndLatitudeDecimalMinute", "gearShootingEndLatitudeDegree", "gearShootingEndLatitudeMinute", "gearShootingEndLatitudeSecond", "gearShootingEndLongitude", "gearShootingEndLongitudeDecimalMinute", "gearShootingEndLongitudeDegree", "gearShootingEndLongitudeMinute", "gearShootingEndLongitudeSecond", "gearShootingStartLatitude", "gearShootingStartLatitudeDecimalMinute", "gearShootingStartLatitudeDegree", "gearShootingStartLatitudeMinute", "gearShootingStartLatitudeSecond", "gearShootingStartLongitude", "gearShootingStartLongitudeDecimalMinute", "gearShootingStartLongitudeDegree", "gearShootingStartLongitudeMinute", "gearShootingStartLongitudeSecond"});

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditFishingOperationUIModel source;
            if (this.properties.contains(evt.getPropertyName()) && (source = (EditFishingOperationUIModel)((Object)evt.getSource())).isFishingOperationRectiligne()) {
                source.computeDistance();
            }
        }
    };
    private final TuttiBeanMonitor<EditFishingOperationUIModel> fishingOperationMonitor;

    public EditFishingOperationUIHandler(FishingOperationsUI parentUi, EditFishingOperationUI ui) {
        super(parentUi.getHandler().getContext(), ui);
        this.parentUi = parentUi;
        this.persistenceService = this.context.getService(PersistenceService.class);
        this.fishingOperationMonitor = new TuttiBeanMonitor("stationNumber", "fishingOperationNumber", "strata", "subStrata", "gearShootingStartLatitude", "gearShootingStartLongitude", "gearShootingStartDate", "gearShootingEndLatitude", "gearShootingEndLongitude", "gearShootingEndDate", "fishingOperationRectiligne", "trawlDistance", "fishingOperationValid", "location", "saisisseur", "vessel", "gear", "multirigAggregation", "comment");
    }

    @Override
    public void beforeInitUI() {
        EditFishingOperationUIModel model = new EditFishingOperationUIModel();
        model.setCoordinateEditorType(this.getConfig().getCoordinateEditorType());
        model.setValidationContext(this.getContext().getValidationContext());
        model.addPropertyChangeListener("strata", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditFishingOperationUIModel source = (EditFishingOperationUIModel)((Object)evt.getSource());
                FishingOperationLocation newStrata = (FishingOperationLocation)evt.getNewValue();
                EditFishingOperationUIHandler.this.onSelectedStrata(source, newStrata);
            }
        });
        model.addPropertyChangeListener("subStrata", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditFishingOperationUIModel source = (EditFishingOperationUIModel)((Object)evt.getSource());
                FishingOperationLocation newStrata = (FishingOperationLocation)evt.getNewValue();
                EditFishingOperationUIHandler.this.onSelectedSubStrata(source, newStrata);
            }
        });
        this.getContext().addPropertyChangeListener("validationContext", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ((EditFishingOperationUIModel)((Object)EditFishingOperationUIHandler.this.getModel())).setValidationContext((String)evt.getNewValue());
            }
        });
        model.addPropertyChangeListener("fishingOperationValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean valid = (Boolean)evt.getNewValue();
                Color color = null;
                Color fontColor = Color.BLACK;
                if (valid == Boolean.TRUE) {
                    color = Color.GREEN;
                } else if (valid == Boolean.FALSE) {
                    color = Color.RED;
                    fontColor = Color.WHITE;
                }
                Component tab = EditFishingOperationUIHandler.this.getTabPanel().getTabComponentAt(0);
                tab.setForeground(fontColor);
                tab.setBackground(color);
            }
        });
        ((EditFishingOperationUI)this.ui).setContextValue(model);
        this.fishingOperationMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {
        ((EditFishingOperationUI)this.ui).getFishingOperationValidPanel().remove(((EditFishingOperationUI)this.ui).getFishingOperationResetRadio());
        final EditFishingOperationUIModel model = (EditFishingOperationUIModel)((Object)this.getModel());
        this.initUI(this.ui);
        List people = this.persistenceService.getAllPerson();
        Collections.sort(people, new Comparator<Person>(){

            @Override
            public int compare(Person o1, Person o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getFirstName().compareTo(o2.getFirstName());
            }
        });
        this.initBeanList(((EditFishingOperationUI)this.ui).getSaisisseurList(), people, model.getSaisisseur());
        this.initBeanComboBox(((EditFishingOperationUI)this.ui).getVesselComboBox(), Lists.newArrayList(), null);
        this.initBeanComboBox(((EditFishingOperationUI)this.ui).getGearComboBox(), Lists.newArrayList(), null);
        Cruise cruise = TuttiUIUtil.getCruise(this.context);
        Preconditions.checkNotNull((Object)cruise, (Object)"Could not find cruise in ui context");
        ((EditFishingOperationUI)this.ui).getMultirigAggregationField().setEnabled(cruise.getMultirigNumber() != 1);
        Program program = TuttiUIUtil.getProgram(this.context);
        Preconditions.checkNotNull((Object)program, (Object)"Could not find program in ui context");
        Zone zone = program.getZone();
        FishingOperationLocation strata = model.getStrata();
        String strataId = strata == null ? null : strata.getId();
        FishingOperationLocation subStrata = model.getSubStrata();
        String substrataId = subStrata == null ? null : subStrata.getId();
        FishingOperationLocation location = model.getLocation();
        String zoneId = zone.getId();
        List stratas = this.persistenceService.getAllFishingOperationStrata(zoneId);
        List subStratas = this.persistenceService.getAllFishingOperationSubStrata(zoneId, strataId);
        List locations = this.persistenceService.getAllFishingOperationLocation(zoneId, strataId, substrataId);
        this.initBeanComboBox(((EditFishingOperationUI)this.ui).getStrataComboBox(), stratas, strata);
        this.initBeanComboBox(((EditFishingOperationUI)this.ui).getSubStrataComboBox(), subStratas, subStrata);
        this.initBeanComboBox(((EditFishingOperationUI)this.ui).getLocationComboBox(), locations, location);
        model.setEmpty(true);
        this.changeValidatorContext(model.getValidationContext(), ((EditFishingOperationUI)this.ui).getValidator());
        this.listenValidatorValid((SimpleBeanValidator)((EditFishingOperationUI)this.ui).getValidator(), model);
        this.setCustomTab(0, model);
        this.listModelIsModify(model);
        GearShootingTabUIModel gearShootingModel = ((EditFishingOperationUI)this.ui).getGearShootingTabContent().getModel();
        gearShootingModel.setAvailableCaracteristics(this.persistenceService.getAllCaracteristic());
        this.setCustomTab(1, gearShootingModel);
        EnvironmentTabUIModel environmentModel = ((EditFishingOperationUI)this.ui).getEnvironmentTabContent().getModel();
        environmentModel.setAvailableCaracteristics(this.persistenceService.getAllCaracteristic());
        this.setCustomTab(2, environmentModel);
        HydrologyTabUIModel hydrologyModel = ((EditFishingOperationUI)this.ui).getHydrologyTabContent().getModel();
        hydrologyModel.setAvailableCaracteristics(this.persistenceService.getAllCaracteristic());
        this.setCustomTab(3, hydrologyModel);
        if ("validate".equals(model.getValidationContext())) {
            PropertyChangeListener pcl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean allModelsValid = EditFishingOperationUIHandler.this.areAllModelsValid();
                    ((EditFishingOperationUI)EditFishingOperationUIHandler.this.ui).getSaveButton().setEnabled(allModelsValid);
                }
            };
            gearShootingModel.addPropertyChangeListener("valid", pcl);
            environmentModel.addPropertyChangeListener("valid", pcl);
            hydrologyModel.addPropertyChangeListener("valid", pcl);
            model.addPropertyChangeListener("valid", pcl);
        } else {
            model.addPropertyChangeListener("valid", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Boolean valid = (Boolean)evt.getNewValue();
                    if (valid != null) {
                        ((EditFishingOperationUI)EditFishingOperationUIHandler.this.ui).getSaveButton().setEnabled(valid);
                    }
                }
            });
        }
        model.addPropertyChangeListener("trawlDistance", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String tooltip = model.getTrawlDistance() != null ? I18n._((String)"tutti.tooltip.distanceInMilles", (Object[])new Object[]{TuttiUIUtil.getDistanceInMilles(model.getTrawlDistance())}) : null;
                ((EditFishingOperationUI)EditFishingOperationUIHandler.this.ui).getTrawlDistanceField().getTextField().setToolTipText(tooltip);
            }
        });
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        this.clearValidators();
        this.closeUI(((EditFishingOperationUI)this.ui).getGearShootingTabContent());
        this.closeUI(((EditFishingOperationUI)this.ui).getEnvironmentTabContent());
        this.closeUI(((EditFishingOperationUI)this.ui).getHydrologyTabContent());
    }

    @Override
    public boolean onHideTab(int currentIndex, int newIndex) {
        boolean result;
        if (this.isAModelModified()) {
            EditFishingOperationUIModel model = (EditFishingOperationUIModel)((Object)this.getModel());
            if (model.isValid()) {
                String message = TuttiEntities.isNew((IdAware)model.getFishingOperation()) ? I18n._((String)"tutti.dialog.askSaveBeforeLeaving.createFishingOperation", (Object[])new Object[0]) : I18n._((String)"tutti.dialog.askSaveBeforeLeaving.saveFishingOperation", (Object[])new Object[0]);
                int answer = this.askSaveBeforeLeaving(message);
                ActionEvent event = new ActionEvent(this, newIndex, null);
                switch (answer) {
                    case 0: {
                        this.doAction(((EditFishingOperationUI)this.ui).getSaveButton(), event);
                        result = true;
                        break;
                    }
                    case 1: {
                        this.doAction(((EditFishingOperationUI)this.ui).getCancelButton(), event);
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
            } else {
                int answer = this.askCancelEditBeforeLeaving(I18n._((String)"tutti.dialog.askCancelEditBeforeLeaving.cancelEditFishingOperation", (Object[])new Object[0]));
                switch (answer) {
                    case 0: {
                        ActionEvent event = new ActionEvent(this, newIndex, null);
                        this.doAction(((EditFishingOperationUI)this.ui).getCancelButton(), event);
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    public void onShowTab(int currentIndex, int newIndex) {
    }

    public void registerValidator() {
        this.registerValidators(((EditFishingOperationUI)this.ui).getValidator());
    }

    @Override
    protected JTabbedPane getTabPanel() {
        return ((EditFishingOperationUI)this.ui).getFishingOperationTabPane();
    }

    @Override
    public SwingValidator<EditFishingOperationUIModel> getValidator() {
        return ((EditFishingOperationUI)this.ui).getValidator();
    }

    public CaracteristicTabUIModel[] getSubModels() {
        return new CaracteristicTabUIModel[]{((EditFishingOperationUI)this.ui).getGearShootingTabContent().getModel(), ((EditFishingOperationUI)this.ui).getEnvironmentTabContent().getModel(), ((EditFishingOperationUI)this.ui).getHydrologyTabContent().getModel()};
    }

    public void uninstallStartDateListener() {
        ((EditFishingOperationUIModel)((Object)this.getModel())).removePropertyChangeListener("gearShootingStartDate", this.startDateListener);
    }

    public void installStartDateListener() {
        ((EditFishingOperationUIModel)((Object)this.getModel())).addPropertyChangeListener("gearShootingStartDate", this.startDateListener);
    }

    public void uninstallCoordinatesListener() {
        ((EditFishingOperationUIModel)((Object)this.getModel())).removePropertyChangeListener(this.coordinatePropertiesListener);
    }

    public void installCoordinatesListener() {
        ((EditFishingOperationUIModel)((Object)this.getModel())).addPropertyChangeListener(this.coordinatePropertiesListener);
    }

    public FishingOperationsUI getParentUi() {
        return this.parentUi;
    }

    public TuttiBeanMonitor<EditFishingOperationUIModel> getFishingOperationMonitor() {
        return this.fishingOperationMonitor;
    }

    @Override
    public void setDate(ActionEvent event, String property) {
        JXDatePicker field = (JXDatePicker)event.getSource();
        Date value = field.getDate();
        Date date = (Date)TuttiUIUtil.getProperty(this.getModel(), property);
        if (value != null && date != null) {
            Calendar cal = DateUtils.toCalendar((Date)date);
            value = DateUtils.setHours((Date)value, (int)cal.get(11));
            value = DateUtils.setMinutes((Date)value, (int)cal.get(12));
        }
        TuttiUIUtil.setProperty(this.getModel(), property, value);
    }

    protected void onSelectedStrata(EditFishingOperationUIModel model, FishingOperationLocation newStrata) {
        model.setSubStrata(null);
        ((EditFishingOperationUI)this.ui).getSubStrataComboBox().setData(null);
        Zone zone = TuttiUIUtil.getProgram(this.context).getZone();
        String zoneId = zone.getId();
        String strataId = newStrata == null ? null : newStrata.getId();
        List subStrata = this.persistenceService.getAllFishingOperationSubStrata(zoneId, strataId);
        List location = this.persistenceService.getAllFishingOperationLocation(zoneId, strataId, null);
        ((EditFishingOperationUI)this.ui).getSubStrataComboBox().setData(subStrata);
        ((EditFishingOperationUI)this.ui).getLocationComboBox().setData(location);
        if (newStrata == null) {
            ((EditFishingOperationUI)this.ui).getStrataComboBox().grabFocus();
        } else if (CollectionUtils.isEmpty((Collection)subStrata)) {
            ((EditFishingOperationUI)this.ui).getLocationComboBox().grabFocus();
        }
    }

    protected void onSelectedSubStrata(EditFishingOperationUIModel model, FishingOperationLocation newSubStrata) {
        model.setLocation(null);
        ((EditFishingOperationUI)this.ui).getLocationComboBox().setData(null);
        Zone zone = TuttiUIUtil.getProgram(this.context).getZone();
        String zoneId = zone.getId();
        FishingOperationLocation strata = model.getStrata();
        String subStrataId = newSubStrata == null ? null : newSubStrata.getId();
        String strataId = strata == null ? null : strata.getId();
        List location = this.persistenceService.getAllFishingOperationLocation(zoneId, strataId, subStrataId);
        ((EditFishingOperationUI)this.ui).getLocationComboBox().setData(location);
        if (newSubStrata == null) {
            ((EditFishingOperationUI)this.ui).getSubStrataComboBox().grabFocus();
        }
    }

    protected boolean areAllModelsValid() {
        CaracteristicTabUIModel[] subModels;
        boolean result = ((EditFishingOperationUIModel)((Object)this.getModel())).isValid();
        for (CaracteristicTabUIModel subModel : subModels = this.getSubModels()) {
            result &= subModel.isValid();
        }
        return result;
    }

    protected boolean isAModelModified() {
        CaracteristicTabUIModel[] subModels;
        boolean result = ((EditFishingOperationUIModel)((Object)this.getModel())).isModify();
        for (CaracteristicTabUIModel subModel : subModels = this.getSubModels()) {
            result |= subModel.isModify();
        }
        return result;
    }

    protected void resetAllModels() {
        for (CaracteristicTabUIModel subModel : this.getSubModels()) {
            subModel.setModify(false);
        }
        ((EditFishingOperationUIModel)((Object)this.getModel())).setModify(false);
    }
}

