/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.SaveFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.ComputeWeightsAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SaveCatchBatchAction;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUI;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class EditFishingOperationAction
extends AbstractTuttiAction<FishingOperationsUIModel, FishingOperationsUI, FishingOperationsUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(EditFishingOperationAction.class);
    protected FishingOperation fishingOperation;
    protected boolean checkPreviousEdit = true;
    protected SaveFishingOperationAction saveFishingOperationAction;
    protected ComputeWeightsAction computeWeightsAction;
    protected SaveCatchBatchAction saveCatchBatchAction;
    private final PropertyChangeListener coordinatePropertiesListener = new PropertyChangeListener(){
        private List<String> properties = Lists.newArrayList((Object[])new String[]{"fishingOperationRectiligne", "gearShootingEndLatitude", "gearShootingEndLatitudeDecimalMinute", "gearShootingEndLatitudeDegree", "gearShootingEndLatitudeMinute", "gearShootingEndLatitudeSecond", "gearShootingEndLongitude", "gearShootingEndLongitudeDecimalMinute", "gearShootingEndLongitudeDegree", "gearShootingEndLongitudeMinute", "gearShootingEndLongitudeSecond", "gearShootingStartLatitude", "gearShootingStartLatitudeDecimalMinute", "gearShootingStartLatitudeDegree", "gearShootingStartLatitudeMinute", "gearShootingStartLatitudeSecond", "gearShootingStartLongitude", "gearShootingStartLongitudeDecimalMinute", "gearShootingStartLongitudeDegree", "gearShootingStartLongitudeMinute", "gearShootingStartLongitudeSecond"});

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditFishingOperationUIModel source;
            if (this.properties.contains(evt.getPropertyName()) && (source = (EditFishingOperationUIModel)((Object)evt.getSource())).isFishingOperationRectiligne()) {
                source.computeDistance();
            }
        }
    };

    public EditFishingOperationAction(FishingOperationsUIHandler handler) {
        super(handler, "editFishingOperation", "edit", null, I18n._((String)"tutti.action.editFishingOperation.tip", (Object[])new Object[0]), true);
    }

    protected EditFishingOperationAction(FishingOperationsUIHandler handler, String name, String icon, String text, String tip, boolean hideBody) {
        super(handler, name, icon, text, tip, hideBody);
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    public void setCheckPreviousEdit(boolean checkPreviousEdit) {
        this.checkPreviousEdit = checkPreviousEdit;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        this.fishingOperation = null;
        this.checkPreviousEdit = true;
        super.releaseAction(event);
    }

    protected SaveFishingOperationAction getSaveFishingOperationAction() {
        if (this.saveFishingOperationAction == null) {
            this.saveFishingOperationAction = new SaveFishingOperationAction(((FishingOperationsUI)this.getUI()).getFishingOperationTabContent().getHandler());
        }
        return this.saveFishingOperationAction;
    }

    protected SaveCatchBatchAction getSaveCatchBatchAction() {
        if (this.saveCatchBatchAction == null) {
            this.saveCatchBatchAction = new SaveCatchBatchAction(((FishingOperationsUI)this.getUI()).getCatchesTabContent().getHandler());
        }
        return this.saveCatchBatchAction;
    }

    protected ComputeWeightsAction getComputeWeightsAction() {
        if (this.computeWeightsAction == null) {
            this.computeWeightsAction = new ComputeWeightsAction(((FishingOperationsUI)this.getUI()).getCatchesTabContent().getHandler());
        }
        return this.computeWeightsAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean canContinue = super.prepareAction(event);
        if (canContinue && this.checkPreviousEdit) {
            FishingOperationsUI ui = (FishingOperationsUI)this.getUI();
            FishingOperationsUIModel model = ui.getModel();
            FishingOperation editFishingOperation = model.getEditFishingOperation();
            String editFishingOperationId = null;
            if (editFishingOperation == null) {
                canContinue = true;
            } else {
                boolean needSave;
                editFishingOperationId = editFishingOperation.getId();
                boolean create = TuttiEntities.isNew((IdAware)editFishingOperation);
                boolean fishingOperationModified = ((FishingOperationsUIHandler)this.getHandler()).isFishingOperationModified();
                boolean catchBatchModified = ((FishingOperationsUIHandler)this.getHandler()).isCatchBatchModified();
                boolean fishingOperationValid = ((FishingOperationsUIHandler)this.getHandler()).isFishingOperationValid();
                boolean catchBatchValid = ((FishingOperationsUIHandler)this.getHandler()).isCatchBatchValid();
                boolean bl = needSave = create || fishingOperationModified || catchBatchModified;
                if (needSave) {
                    boolean canSave = fishingOperationValid && catchBatchValid;
                    canContinue = false;
                    if (canSave) {
                        String message = create ? I18n._((String)"tutti.dialog.askSaveBeforeLeaving.createFishingOperation", (Object[])new Object[0]) : (fishingOperationModified ? I18n._((String)"tutti.dialog.askSaveBeforeLeaving.saveFishingOperation", (Object[])new Object[0]) : I18n._((String)"tutti.dialog.askSaveBeforeLeaving.saveCatchBatch", (Object[])new Object[0]));
                        int answer = ((FishingOperationsUIHandler)this.getHandler()).askSaveBeforeLeaving(message);
                        switch (answer) {
                            case 0: {
                                if (fishingOperationModified) {
                                    this.getSaveFishingOperationAction().setUpdateUI(false);
                                    this.getSaveFishingOperationAction().actionPerformed(event);
                                }
                                if (catchBatchModified) {
                                    this.getSaveCatchBatchAction().setUpdateUI(false);
                                    this.getSaveCatchBatchAction().actionPerformed(event);
                                }
                                canContinue = true;
                                break;
                            }
                            case 1: {
                                canContinue = true;
                            }
                        }
                    } else {
                        String message = fishingOperationValid ? I18n._((String)"tutti.dialog.askCancelEditBeforeLeaving.cancelEditCatchBatch", (Object[])new Object[0]) : I18n._((String)"tutti.dialog.askCancelEditBeforeLeaving.cancelEditFishingOperation", (Object[])new Object[0]);
                        int answer = ((FishingOperationsUIHandler)this.getHandler()).askCancelEditBeforeLeaving(message);
                        switch (answer) {
                            case 0: {
                                canContinue = true;
                            }
                        }
                    }
                }
            }
            if (!canContinue) {
                FishingOperation selectFishingOperation = model.getFishingOperation(editFishingOperationId);
                model.setEditionAdjusting(true);
                try {
                    model.setSelectedFishingOperation(selectFishingOperation);
                }
                finally {
                    model.setEditionAdjusting(false);
                }
            }
        }
        return canContinue;
    }

    @Override
    protected void doAction(ActionEvent event) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Try to edit fishingOperation: " + this.fishingOperation));
        }
        FishingOperationsUI ui = (FishingOperationsUI)this.getUI();
        FishingOperationsUIModel model = ui.getModel();
        if (log.isInfoEnabled()) {
            log.info((Object)("Edit in ui fishingOperation: " + this.fishingOperation));
        }
        model.setEditFishingOperation(this.fishingOperation);
        this.loadFishingOperation(this.fishingOperation);
        this.loadCatchBatch(this.fishingOperation, true);
        JTabbedPane form = ui.getTabPane();
        JLabel noContentPane = ui.getNoTraitPane();
        if (this.fishingOperation == null) {
            ui.remove(form);
            ui.add((Component)noContentPane, "Center");
        } else {
            ui.remove(noContentPane);
            ui.add((Component)form, "Center");
            ui.getFishingOperationTabContent().getFishingOperationTabPane().setSelectedIndex(0);
            if (this.checkPreviousEdit) {
                ui.getTabPane().setSelectedIndex(0);
            }
        }
        model.addPropertyChangeListener(this.coordinatePropertiesListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((FishingOperationsUI)EditFishingOperationAction.this.getUI()).repaint();
            }
        });
    }

    public void loadFishingOperation(FishingOperation bean) {
        EditFishingOperationUI ui = ((FishingOperationsUI)this.getUI()).getFishingOperationTabContent();
        EditFishingOperationUIHandler handler = ui.getHandler();
        EditFishingOperationUIModel editFishingOperationUIModel = ui.getModel();
        handler.uninstallStartDateListener();
        handler.uninstallCoordinatesListener();
        if (bean == null) {
            editFishingOperationUIModel.fromBean(new FishingOperation());
            editFishingOperationUIModel.setFishingOperation(bean);
            handler.clearValidators();
            handler.resetAllModels();
        } else {
            FishingOperationLocation strata = bean.getStrata();
            FishingOperationLocation subStrata = bean.getSubStrata();
            FishingOperationLocation location = bean.getLocation();
            Cruise cruise = bean.getCruise();
            if (cruise != null) {
                ui.getGearComboBox().setData((List)Lists.newArrayList((Iterable)cruise.getGear()));
                ui.getVesselComboBox().setData((List)Lists.newArrayList((Iterable)cruise.getVessel()));
            }
            editFishingOperationUIModel.fromBean(bean);
            editFishingOperationUIModel.setStrata(null);
            editFishingOperationUIModel.setSubStrata(null);
            editFishingOperationUIModel.setLocation(null);
            editFishingOperationUIModel.convertGearShootingCoordinatesDDToDMS();
            if (strata != null) {
                ui.getStrataComboBox().setSelectedItem((Object)strata);
            }
            if (subStrata != null) {
                ui.getSubStrataComboBox().setSelectedItem((Object)subStrata);
            }
            if (location != null) {
                ui.getLocationComboBox().setSelectedItem((Object)location);
            }
            editFishingOperationUIModel.setFishingOperation(bean);
            List<Person> saisisseur = editFishingOperationUIModel.getSaisisseur();
            ui.getSaisisseurList().getModel().setSelected(saisisseur);
            editFishingOperationUIModel.setEmpty(false);
            GearShootingTabUI gearShootingTab = ui.getGearShootingTabContent();
            gearShootingTab.getHandler().reset(bean);
            EnvironmentTabUI environmentTab = ui.getEnvironmentTabContent();
            environmentTab.getHandler().reset(bean);
            HydrologyTabUI hydrologyTab = ui.getHydrologyTabContent();
            hydrologyTab.getHandler().reset(bean);
            editFishingOperationUIModel.setModify(false);
            handler.getFishingOperationMonitor().clearModified();
            handler.registerValidator();
        }
        handler.installStartDateListener();
        handler.installCoordinatesListener();
    }

    public void loadCatchBatch(FishingOperation bean, boolean loadOtherTabs) {
        CatchBatch batch;
        boolean empty = bean == null || TuttiEntities.isNew((IdAware)bean);
        EditCatchesUI ui = ((FishingOperationsUI)this.getUI()).getCatchesTabContent();
        TuttiBeanMonitor<EditCatchesUIModel> catchBatchMonitor = ui.getHandler().getCatchBatchMonitor();
        EditCatchesUIModel catchesUIModel = ui.getModel();
        catchesUIModel.reset();
        if (empty) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Create a new CatchBatch (fishing operation is null)");
            }
            batch = new CatchBatch();
            batch.setFishingOperation(bean);
        } else {
            String operationId = bean.getId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Load existing CatchBatch from operation id: " + operationId));
            }
            PersistenceService persistenceService = this.getService(PersistenceService.class);
            batch = persistenceService.getCatchBatchFromFishingOperation(operationId);
            batch.setFishingOperation(bean);
        }
        catchesUIModel.setCatchBatch(batch);
        catchesUIModel.setFishingOperation(bean);
        catchesUIModel.fromBean(batch);
        catchesUIModel.setModify(false);
        catchBatchMonitor.clearModified();
        Decorator<FishingOperation> decorator = this.getDecorator(FishingOperation.class, null);
        String fishingOperationText = bean == null ? null : I18n._((String)"tutti.label.traitReminder", (Object[])new Object[]{decorator.toString((Object)bean)});
        ui.getCatchesCaracteristicsTabPane().setTitle(fishingOperationText);
        ui.getSpeciesTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        if (loadOtherTabs) {
            ui.getSpeciesTabContent().getHandler().selectFishingOperation(bean);
        }
    }
}

