
package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: SelectOtherSpeciesAction.java 476 2013-02-25 20:44:07Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/SelectOtherSpeciesAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.*;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

/**
 * Action to select a species which is not in the referent list.
 * 
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.1
 */
public class SelectOtherSpeciesAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(AddSpeciesAction.class);

    protected Species selectedSpecies;

    public SelectOtherSpeciesAction(EditProtocolUIHandler handler) {
        super(handler,
              "selectOtherSpecies",
              null,
              _("tutti.action.selectOtherSpecies.text"),
              _("tutti.action.selectOtherSpecies.tip"),
              false
        );
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean result = super.prepareAction(event);
        EditProtocolUIModel model = getModel();

        List<Species> species = Lists.newArrayList(model.getAllSynonyms());

        selectedSpecies = getHandler().openSelectOtherSpeciesDialog(
                _("tutti.title.selectSpecies"), species);

        result &= selectedSpecies != null;
        return result;
    }

    @Override
    protected void doAction(ActionEvent event) {
        String decoratedSynonym = decorate(selectedSpecies);
        String taxonId = String.valueOf(selectedSpecies.getReferenceTaxonId());
        selectedSpecies = getModel().getAllReferentSpeciesByTaxonId().get(taxonId);
        String decoratedReferent = decorate(selectedSpecies);
        sendMessage(_("tutti.flash.information.species.replaced", decoratedSynonym, decoratedReferent));
        getUI().getSpeciesComboBox().setSelectedItem(selectedSpecies);
    }

}
