package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id: NewFishingOperationAction.java 418 2013-02-14 23:59:54Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/NewFishingOperationAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;

import java.awt.event.ActionEvent;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * To create a new fishing operation.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class NewFishingOperationAction extends EditFishingOperationAction {

    private static final long serialVersionUID = 1L;

    public NewFishingOperationAction(FishingOperationsUIHandler handler) {
        super(handler,
              "newFishingOperation",
              "add",
              null,
              _("tutti.action.newFishingOperation.tip"),
              true);
    }

    @Override
    protected void doAction(ActionEvent event) throws Exception {

        FishingOperationsUIModel model = getModel();

        // deselect selected fishingOperation
        // Will remove the selection fishing operation from the comboBox

        model.setEditionAdjusting(true);
        try {
            model.setSelectedFishingOperation(null);
        } finally {
            model.setEditionAdjusting(false);
        }

        // creates a empty bean

        FishingOperation newFishingOperation = new FishingOperation();
        Cruise cruise = TuttiUIUtil.getCruise(getContext());
        newFishingOperation.setCruise(cruise);

        //TODO Should select vessel from possible one ?
        List<Vessel> vessels = cruise.getVessel();
        if (vessels.size() == 1) {
            newFishingOperation.setVessel(vessels.get(0));
        }

        //TODO Should select gear from possible one ?
        List<Gear> gears = cruise.getGear();
        if (gears.size() == 1) {
            newFishingOperation.setGear(gears.get(0));
        }

        if (cruise.getMultirigNumber() == 1) {
            newFishingOperation.setMultirigAggregation("1");
        }

        newFishingOperation.setGearShootingStartDate(null);
        newFishingOperation.setGearShootingEndDate(null);
        setFishingOperation(newFishingOperation);

        super.doAction(event);
    }
}
