package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportProtocolAction.java 384 2013-02-10 15:01:31Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/ImportProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;
import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * Opens a file chooser and imports the protocol from the selected file.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportProtocolAction extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ImportProtocolAction.class);

    public static final JAXXContextEntryDef<TuttiProtocol> IMPORT_PROTOCOL_ENTRY = new JAXXContextEntryDef<TuttiProtocol>("importProtocol", TuttiProtocol.class);

    private File file;

    public ImportProtocolAction(SelectCruiseUIHandler handler) {
        super(handler,
              "importProtocol",
              "import",
              _("tutti.action.importProtocol"),
              _("tutti.action.importProtocol.tip"),
              true
        );
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {

        // choose file to import
        file = TuttiUIUtil.chooseFile(
                getContext().getMainUI(),
                _("tutti.title.choose.protocolImportFile"),
                _("tutti.action.chooseProtocolFile"),
                null,
                "^.+\\.tuttiProtocol$", _("tutti.file.protocol")
        );
        boolean doAction = file != null;
        if (doAction) {
            super.prepareAction(event);
        }
        return doAction;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        file = null;
    }

    @Override
    protected void doAction(ActionEvent e) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("TODO Import protocol!");
        }

        if (log.isInfoEnabled()) {
            log.info("Will import protocol file: " + file);
        }

        // import protocol
        TuttiProtocolImportExportService service =
                getService(TuttiProtocolImportExportService.class);
        TuttiProtocol protocol = service.importProtocol(file);

        sendMessage("Protocole [" + protocol.getName() + "] lu depuis le fichier.");

        IMPORT_PROTOCOL_ENTRY.setContextValue(getContext().getMainUI(), protocol);

        // remove id
        protocol.setId(null);

        getContext().setProtocolId(null);
        getContext().setScreen(TuttiScreen.EDIT_PROTOCOL);
    }
}
