package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProtocolAction.java 349 2013-02-06 10:54:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/EditProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;

import static org.nuiton.i18n.I18n._;

/**
 * Opens the protocol edition screen.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class EditProtocolAction extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(EditProtocolAction.class);

    public EditProtocolAction(SelectCruiseUIHandler handler) {
        super(handler,
              "editProtocol",
              "edit",
              _("tutti.action.editProtocol"),
              _("tutti.action.editProtocol.tip"),
              true
        );
    }

    @Override
    protected void doAction(ActionEvent e) {
        TuttiProtocol protocol = getModel().getProtocol();
        Preconditions.checkNotNull(protocol);
        if (log.isInfoEnabled()) {
            log.info("Edit protocol: " + protocol.getId());
        }
        getContext().setProtocolId(protocol.getId());
        getContext().setScreen(TuttiScreen.EDIT_PROTOCOL);
    }
}
