package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProtocolUIModel.java 193 2013-01-14 16:35:12Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/EditProtocolUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.List;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class EditProtocolUIModel extends AbstractTuttiTableUIModel<TuttiProtocol, EditProtocolSpeciesRowModel, EditProtocolUIModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_COMMENT = "comment";

    public static final String PROPERTY_NAME = "name";

    public static final String PROPERTY_GEAR_PMFM_ID = "gearPmfmId";

    public static final String PROPERTY_ENVIRONMENT_PMFM_ID = "environmentPmfmId";

    public static final String PROPERTY_HYDROLOGY_PMFM_ID = "hydrologyPmfmId";

    public static final String PROPERTY_SAMPLE_CATEGORY_ORDER = "sampleCategoryOrder";
    
    public static final String PROPERTY_REMOVE_SPECIES_ENABLED = "removeSpeciesEnabled";

    protected String name;

    protected String comment;

    protected List<String> gearPmfmId;

    protected List<String> environmentPmfmId;

    protected List<String> hydrologyPmfmId;

    protected List<SampleCategoryEnum> sampleCategoryOrder = Lists.newArrayList(
            SampleCategoryEnum.sortedUnsorted,
            SampleCategoryEnum.size,
            SampleCategoryEnum.sex,
            SampleCategoryEnum.maturity,
            SampleCategoryEnum.age,
            SampleCategoryEnum.weight,
            SampleCategoryEnum.countIfNoFrequency,
            SampleCategoryEnum.calcifySample);
    
    /**
     * Can user remove a selected species?
     *
     * @since 0.3
     */
    protected boolean removeSpeciesEnabled;

    protected static Binder<EditProtocolUIModel, TuttiProtocol> toBeanBinder =
            BinderFactory.newBinder(EditProtocolUIModel.class,
                                    TuttiProtocol.class);

    protected static Binder<TuttiProtocol, EditProtocolUIModel> fromBeanBinder =
            BinderFactory.newBinder(TuttiProtocol.class, EditProtocolUIModel.class);

    public EditProtocolUIModel() {
        super(TuttiProtocol.class, fromBeanBinder, toBeanBinder);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        Object oldValue = getName();
        this.name = name;
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        Object oldValue = getComment();
        this.comment = comment;
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public List<String> getGearPmfmId() {
        return gearPmfmId;
    }

    public void setGearPmfmId(List<String> gearPmfmId) {
        Object oldValue = getGearPmfmId();
        this.gearPmfmId = gearPmfmId;
        firePropertyChange(PROPERTY_GEAR_PMFM_ID, oldValue, gearPmfmId);
    }

    public void setGearPmfm(List<Caracteristic> gearPmfm) {
        List<String> ids = Lists.newArrayList();
        for (Caracteristic caracteristic : gearPmfm) {
            ids.add(caracteristic.getId());
        }
        setGearPmfmId(ids);
    }

    public List<String> getEnvironmentPmfmId() {
        return environmentPmfmId;
    }

    public void setEnvironmentPmfmId(List<String> environmentPmfmId) {
        Object oldValue = getEnvironmentPmfmId();
        this.environmentPmfmId = environmentPmfmId;
        firePropertyChange(PROPERTY_ENVIRONMENT_PMFM_ID, oldValue, environmentPmfmId);
    }

    public void setEnvironmentPmfm(List<Caracteristic> environmentPmfm) {
        List<String> ids = Lists.newArrayList();
        for (Caracteristic caracteristic : environmentPmfm) {
            ids.add(caracteristic.getId());
        }
        setEnvironmentPmfmId(ids);
    }

    public List<String> getHydrologyPmfmId() {
        return hydrologyPmfmId;
    }

    public void setHydrologyPmfmId(List<String> hydrologyPmfmId) {
        Object oldValue = getHydrologyPmfmId();
        this.hydrologyPmfmId = hydrologyPmfmId;
        firePropertyChange(PROPERTY_HYDROLOGY_PMFM_ID, oldValue, hydrologyPmfmId);
    }

    public void setHydrologyPmfm(List<Caracteristic> hydrologyPmfm) {
        List<String> ids = Lists.newArrayList();
        for (Caracteristic caracteristic : hydrologyPmfm) {
            ids.add(caracteristic.getId());
        }
        setHydrologyPmfmId(ids);
    }

    public List<SampleCategoryEnum> getSampleCategoryOrder() {
        return sampleCategoryOrder;
    }

    public void setSampleCategoryOrder(List<SampleCategoryEnum> sampleCategoryOrder) {
        Object oldValue = getSampleCategoryOrder();
        this.sampleCategoryOrder = sampleCategoryOrder;
        firePropertyChange(PROPERTY_SAMPLE_CATEGORY_ORDER, oldValue, sampleCategoryOrder);
    }
    
    public boolean isRemoveSpeciesEnabled() {
        return removeSpeciesEnabled;
    }

    public void setRemoveSpeciesEnabled(boolean removeSpeciesEnabled) {
        Object oldValue = isRemoveSpeciesEnabled();
        this.removeSpeciesEnabled = removeSpeciesEnabled;
        firePropertyChange(PROPERTY_REMOVE_SPECIES_ENABLED, oldValue, removeSpeciesEnabled);
    }
}