package fr.ifremer.tutti.ui.swing.util.table;

/*
 * #%L
 * Tutti :: UI
 * $Id: AbstractTuttiTableUIModel.java 135 2013-01-01 16:10:44Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/table/AbstractTuttiTableUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;

import java.util.List;

/**
 * @param <E> type of incoming bean to edit
 * @param <R> type of the row of the table model
 * @param <B> type of this model
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public abstract class AbstractTuttiTableUIModel<E, R extends AbstractTuttiBeanUIModel, B extends AbstractTuttiTableUIModel<E, R, B>> extends AbstractTuttiBeanUIModel<E, B> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_ROWS = "rows";

    protected List<R> rows;

    protected AbstractTuttiTableUIModel(Class<E> entityType,
                                        Binder<E, B> fromBeanBinder,
                                        Binder<B, E> toBeanBinder) {
        super(entityType, fromBeanBinder, toBeanBinder);
    }

    public List<R> getRows() {
        return rows;
    }

    public void setRows(List<R> rows) {
        if (rows == null) {
            rows = Lists.newArrayList();
        }
        this.rows = rows;

        // always propagates (since empty list will not fire and we want it)
        firePropertyChange(PROPERTY_ROWS, null, rows);
    }

    public int getRowCount() {
        return rows == null ? 0 : rows.size();
    }
}