package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

/*
 * #%L
 * Tutti :: UI
 * $Id: CreateSpeciesBatchUIModel.java 135 2013-01-01 16:10:44Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/split/CreateSpeciesBatchUIModel.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;

import java.util.List;

/**
 * Model of {@link CreateSpeciesBatchUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class CreateSpeciesBatchUIModel extends AbstractTuttiBeanUIModel<CreateSpeciesBatchUIModel, CreateSpeciesBatchUIModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_AVAILABLE_SPECIES = "availableSpecies";

    public static final String PROPERTY_SPECIES = "species";

    public static final String PROPERTY_BATCH_WEIGHT = "batchWeight";

    /**
     * All available species (sets by protocol).
     *
     * @since 0.3
     */
    protected List<Species> availableSpecies;

    /**
     * Species to select.
     *
     * @since 0.3
     */
    protected Species species;

    /**
     * Incoming batch weight to split.
     *
     * @since 0.3
     */
    protected Float batchWeight;

    public CreateSpeciesBatchUIModel() {
        super(CreateSpeciesBatchUIModel.class, null, null);
    }

    public List<Species> getAvailableSpecies() {
        return availableSpecies;
    }

    public void setAvailableSpecies(List<Species> availableSpecies) {
        Object oldValue = getAvailableSpecies();
        this.availableSpecies = availableSpecies;
        firePropertyChange(PROPERTY_AVAILABLE_SPECIES, oldValue, availableSpecies);
    }

    public Species getSpecies() {
        return species;
    }

    public void setSpecies(Species species) {
        Object oldSpecies = getSpecies();
        this.species = species;
        firePropertyChange(PROPERTY_SPECIES, oldSpecies, getSpecies());
    }

    public Float getBatchWeight() {
        return batchWeight;
    }

    public void setBatchWeight(Float batchWeight) {
        Object oldValue = getBatchWeight();
        this.batchWeight = batchWeight;
        firePropertyChange(PROPERTY_BATCH_WEIGHT, oldValue, batchWeight);
    }

}