package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUI;
import fr.ifremer.tutti.ui.swing.util.editor.SimpleTimeEditor;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.TimeEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditFishingOperationUI extends JPanel implements TuttiUI<EditFishingOperationUIModel, EditFishingOperationUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_CREATE_FISHING_OPERATION_ACTIONS_VISIBLE = "createFishingOperationActions.visible";
    public static final String BINDING_DATE_FIELD_DATE = "dateField.date";
    public static final String BINDING_DISTANCE_CHALUTEE_FIELD_ENABLED = "distanceChaluteeField.enabled";
    public static final String BINDING_DISTANCE_CHALUTEE_FIELD_MODEL = "distanceChaluteeField.model";
    public static final String BINDING_DISTANCE_CHALUTEE_FIELD_NUMBER_PATTERN = "distanceChaluteeField.numberPattern";
    public static final String BINDING_DUREE_FIELD_TEXT = "dureeField.text";
    public static final String BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED = "fishingOperationInvalidRadio.selected";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL = "fishingOperationNumberField.model";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN = "fishingOperationNumberField.numberPattern";
    public static final String BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED = "fishingOperationRectiligneCheckBox.selected";
    public static final String BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED = "fishingOperationResetRadio.selected";
    public static final String BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED = "fishingOperationValidRadio.selected";
    public static final String BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE = "gearShootingEndDateField.date";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_FIELD_TEXT = "gearShootingEndLongitudeField.text";
    public static final String BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE = "gearShootingEndTimeField.date";
    public static final String BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE = "gearShootingStartDateField.date";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_FIELD_TEXT = "gearShootingStartLongitudeField.text";
    public static final String BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE = "gearShootingStartTimeField.date";
    public static final String BINDING_LOCATION_COMBO_BOX_SELECTED_ITEM = "locationComboBox.selectedItem";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_STATION_NUMBER_FIELD_TEXT = "stationNumberField.text";
    public static final String BINDING_STRATA_COMBO_BOX_SELECTED_ITEM = "strataComboBox.selectedItem";
    public static final String BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM = "subStrataComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditFishingOperationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentField")
    protected JTextArea commentField;
    protected JScrollPane commentPane;
    protected JPanel createFishingOperationActions;
    @ValidatorField( validatorId = "validator",  propertyName = "date",  editorName = "dateField")
    protected JXDatePicker dateField;
    protected JLabel dateLabel;
    protected NumberEditor distanceChaluteeField;
    protected JLabel distanceChaluteeLabel;
    protected JTextField dureeField;
    protected JLabel dureeLabel;
    protected TabInfo environmentTab;
    protected EnvironmentTabUI environmentTabContent;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JRadioButton fishingOperationInvalidRadio;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperationNumber",  editorName = "fishingOperationNumberField")
    protected NumberEditor fishingOperationNumberField;
    protected JLabel fishingOperationNumberLabel;
    protected JPanel fishingOperationPane;
    protected JCheckBox fishingOperationRectiligneCheckBox;
    protected JRadioButton fishingOperationResetRadio;
    protected JTabbedPane fishingOperationTabPane;
    protected JAXXButtonGroup fishingOperationValid;
    protected JToolBar fishingOperationValidPanel;
    protected JRadioButton fishingOperationValidRadio;
    protected Table gearCaracteristicsTable;
    protected JLabel gearDateLabel;
    protected JLabel gearLatitudeLabel;
    protected JLabel gearLongitudeLabel;
    protected JXDatePicker gearShootingEndDateField;
    protected JLabel gearShootingEndLabel;
    protected JTextField gearShootingEndLatitudeLabel;
    protected JTextField gearShootingEndLongitudeField;
    protected SimpleTimeEditor gearShootingEndTimeField;
    protected JXDatePicker gearShootingStartDateField;
    protected JLabel gearShootingStartLabel;
    protected JTextField gearShootingStartLatitudeLabel;
    protected JTextField gearShootingStartLongitudeField;
    protected SimpleTimeEditor gearShootingStartTimeField;
    protected GearShootingTabUI gearShootingTabContent;
    protected JLabel gearTimeLabel;
    protected Table generalForm;
    protected EditFishingOperationUIHandler handler;
    protected EditFishingOperationUI homePanel = this;
    protected HydrologyTabUI hydrologyTabContent;
    protected JButton importCasinoButton;
    protected BeanComboBox<FishingOperationLocation> locationComboBox;
    protected JLabel locationLabel;
    protected EditFishingOperationUIModel model;
    protected JLabel noTraitPane;
    protected JButton resetValidStateButton;
    @ValidatorField( validatorId = "validator",  propertyName = "saisisseur",  editorName = "saisisseurList")
    protected BeanDoubleList<Person> saisisseurList;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "stationNumber",  editorName = "stationNumberField")
    protected JTextField stationNumberField;
    protected JLabel stationNumberLabel;
    protected BeanComboBox<FishingOperationLocation> strataComboBox;
    protected JLabel strataLabel;
    protected BeanComboBox<FishingOperationLocation> subStrataComboBox;
    protected JLabel subStrataLabel;
    protected TabInfo traitGearShootingTab;
    protected TabInfo traitGeneralTab;
    protected TabInfo traitHydrologyTabContent;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditFishingOperationUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private HBox $HBox0;
    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditFishingOperationUI(FishingOperationsUI parentUI) {
        EditFishingOperationUIHandler handler = new EditFishingOperationUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public EditFishingOperationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI() {
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__dateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "date");
    }

    public void doActionPerformed__on__fishingOperationInvalidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.FALSE);
    }

    public void doActionPerformed__on__fishingOperationValidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.TRUE);
    }

    public void doActionPerformed__on__gearShootingEndDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingEndDate");
    }

    public void doActionPerformed__on__gearShootingStartDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingStartDate");
    }

    public void doActionPerformed__on__importCasinoButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importCasino();
    }

    public void doActionPerformed__on__resetValidStateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(null);
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doItemStateChanged__on__fishingOperationRectiligneCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "fishingOperationRectiligne");
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__gearShootingEndLatitudeLabel(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingEndLatitude(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__gearShootingEndLongitudeField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingEndLongitude(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__gearShootingStartLatitudeLabel(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingStartLatitude(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__gearShootingStartLongitudeField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setGearShootingStartLongitude(((JTextField)event.getSource()).getText());
    }

    public void doKeyReleased__on__stationNumberField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "stationNumber");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JPanel getCreateFishingOperationActions() {
        return createFishingOperationActions;
    }

    public JXDatePicker getDateField() {
        return dateField;
    }

    public JLabel getDateLabel() {
        return dateLabel;
    }

    public NumberEditor getDistanceChaluteeField() {
        return distanceChaluteeField;
    }

    public JLabel getDistanceChaluteeLabel() {
        return distanceChaluteeLabel;
    }

    public JTextField getDureeField() {
        return dureeField;
    }

    public JLabel getDureeLabel() {
        return dureeLabel;
    }

    public TabInfo getEnvironmentTab() {
        return environmentTab;
    }

    public EnvironmentTabUI getEnvironmentTabContent() {
        return environmentTabContent;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public JRadioButton getFishingOperationInvalidRadio() {
        return fishingOperationInvalidRadio;
    }

    public NumberEditor getFishingOperationNumberField() {
        return fishingOperationNumberField;
    }

    public JLabel getFishingOperationNumberLabel() {
        return fishingOperationNumberLabel;
    }

    public JPanel getFishingOperationPane() {
        return fishingOperationPane;
    }

    public JCheckBox getFishingOperationRectiligneCheckBox() {
        return fishingOperationRectiligneCheckBox;
    }

    public JRadioButton getFishingOperationResetRadio() {
        return fishingOperationResetRadio;
    }

    public JTabbedPane getFishingOperationTabPane() {
        return fishingOperationTabPane;
    }

    public JAXXButtonGroup getFishingOperationValid() {
        return fishingOperationValid;
    }

    public JToolBar getFishingOperationValidPanel() {
        return fishingOperationValidPanel;
    }

    public JRadioButton getFishingOperationValidRadio() {
        return fishingOperationValidRadio;
    }

    public Table getGearCaracteristicsTable() {
        return gearCaracteristicsTable;
    }

    public JLabel getGearDateLabel() {
        return gearDateLabel;
    }

    public JLabel getGearLatitudeLabel() {
        return gearLatitudeLabel;
    }

    public JLabel getGearLongitudeLabel() {
        return gearLongitudeLabel;
    }

    public JXDatePicker getGearShootingEndDateField() {
        return gearShootingEndDateField;
    }

    public JLabel getGearShootingEndLabel() {
        return gearShootingEndLabel;
    }

    public JTextField getGearShootingEndLatitudeLabel() {
        return gearShootingEndLatitudeLabel;
    }

    public JTextField getGearShootingEndLongitudeField() {
        return gearShootingEndLongitudeField;
    }

    public SimpleTimeEditor getGearShootingEndTimeField() {
        return gearShootingEndTimeField;
    }

    public JXDatePicker getGearShootingStartDateField() {
        return gearShootingStartDateField;
    }

    public JLabel getGearShootingStartLabel() {
        return gearShootingStartLabel;
    }

    public JTextField getGearShootingStartLatitudeLabel() {
        return gearShootingStartLatitudeLabel;
    }

    public JTextField getGearShootingStartLongitudeField() {
        return gearShootingStartLongitudeField;
    }

    public SimpleTimeEditor getGearShootingStartTimeField() {
        return gearShootingStartTimeField;
    }

    public GearShootingTabUI getGearShootingTabContent() {
        return gearShootingTabContent;
    }

    public JLabel getGearTimeLabel() {
        return gearTimeLabel;
    }

    public Table getGeneralForm() {
        return generalForm;
    }

    public EditFishingOperationUIHandler getHandler() {
        return handler;
    }

    public HydrologyTabUI getHydrologyTabContent() {
        return hydrologyTabContent;
    }

    public JButton getImportCasinoButton() {
        return importCasinoButton;
    }

    public BeanComboBox<FishingOperationLocation> getLocationComboBox() {
        return locationComboBox;
    }

    public JLabel getLocationLabel() {
        return locationLabel;
    }

    public EditFishingOperationUIModel getModel() {
        return model;
    }

    public JLabel getNoTraitPane() {
        return noTraitPane;
    }

    public JButton getResetValidStateButton() {
        return resetValidStateButton;
    }

    public BeanDoubleList<Person> getSaisisseurList() {
        return saisisseurList;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JTextField getStationNumberField() {
        return stationNumberField;
    }

    public JLabel getStationNumberLabel() {
        return stationNumberLabel;
    }

    public BeanComboBox<FishingOperationLocation> getStrataComboBox() {
        return strataComboBox;
    }

    public JLabel getStrataLabel() {
        return strataLabel;
    }

    public BeanComboBox<FishingOperationLocation> getSubStrataComboBox() {
        return subStrataComboBox;
    }

    public JLabel getSubStrataLabel() {
        return subStrataLabel;
    }

    public TabInfo getTraitGearShootingTab() {
        return traitGearShootingTab;
    }

    public TabInfo getTraitGeneralTab() {
        return traitGeneralTab;
    }

    public TabInfo getTraitHydrologyTabContent() {
        return traitHydrologyTabContent;
    }

    public SwingValidator<EditFishingOperationUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(SwingUtil.boxComponentWithJxLayer(commentField));
    }

    protected void addChildrenToCreateFishingOperationActions() {
        if (!allComponentsCreated) {
            return;
        }
        createFishingOperationActions.add(cancelButton);
        createFishingOperationActions.add(saveButton);
    }

    protected void addChildrenToFishingOperationInvalidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationInvalidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationInvalidRadio); }
    }

    protected void addChildrenToFishingOperationPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationPane.add(fishingOperationTabPane, BorderLayout.CENTER);
        fishingOperationPane.add($JPanel4, BorderLayout.SOUTH);
    }

    protected void addChildrenToFishingOperationResetRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationResetRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationResetRadio); }
    }

    protected void addChildrenToFishingOperationTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationTabPane.add(generalForm);
        fishingOperationTabPane.add(gearShootingTabContent);
        fishingOperationTabPane.add(environmentTabContent);
        fishingOperationTabPane.add(hydrologyTabContent);
        traitGeneralTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 0));
        fishingOperationTabPane.setTitleAt(0, _("tutti.label.tab.fishingOperation.general"));
        traitGearShootingTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 1));
        fishingOperationTabPane.setTitleAt(1, _("tutti.label.tab.fishingOperation.gearShooting"));
        environmentTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 2));
        fishingOperationTabPane.setTitleAt(2, _("tutti.label.tab.fishingOperation.environment"));
        traitHydrologyTabContent.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 3));
        fishingOperationTabPane.setTitleAt(3, _("tutti.label.tab.fishingOperation.hydrology"));
    }

    protected void addChildrenToFishingOperationValidPanel() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationValidPanel.add(resetValidStateButton, BorderLayout.WEST);
        fishingOperationValidPanel.add(fishingOperationResetRadio, BorderLayout.EAST);
    }

    protected void addChildrenToFishingOperationValidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationValidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationValidRadio); }
    }

    protected void addChildrenToGearCaracteristicsTable() {
        if (!allComponentsCreated) {
            return;
        }
        gearCaracteristicsTable.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLatitudeLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLongitudeLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearDateLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearTimeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLatitudeLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLongitudeField, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartDateField, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartTimeField, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLatitudeLabel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLongitudeField, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndDateField, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndTimeField, new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToGeneralForm() {
        if (!allComponentsCreated) {
            return;
        }
        generalForm.add(stationNumberLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(stationNumberField), new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(fishingOperationNumberLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(fishingOperationNumberField), new GridBagConstraints(3, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(dateLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(dateField), new GridBagConstraints(5, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(strataLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(strataComboBox, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(subStrataLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(subStrataComboBox, new GridBagConstraints(3, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(locationLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(locationComboBox, new GridBagConstraints(5, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel0, new GridBagConstraints(0, 2, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(fishingOperationValidPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($HBox0, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel1, new GridBagConstraints(2, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(fishingOperationRectiligneCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel2, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(dureeLabel, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(dureeField, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel3, new GridBagConstraints(0, 5, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(saisisseurList), new GridBagConstraints(0, 6, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(commentPane, new GridBagConstraints(0, 7, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(fishingOperationPane, BorderLayout.CENTER);
        add(noTraitPane);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
    }

    protected void createCreateFishingOperationActions() {
        $objectMap.put("createFishingOperationActions", createFishingOperationActions = new JPanel());
        
        createFishingOperationActions.setName("createFishingOperationActions");
        createFishingOperationActions.setLayout(new GridLayout(1,0));
    }

    protected void createDateField() {
        $objectMap.put("dateField", dateField = new JXDatePicker());
        
        dateField.setName("dateField");
        dateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dateField"));
    }

    protected void createDateLabel() {
        $objectMap.put("dateLabel", dateLabel = new JLabel());
        
        dateLabel.setName("dateLabel");
        dateLabel.setText(_("tutti.label.fishingOperation.date"));
    }

    protected void createDistanceChaluteeField() {
        $objectMap.put("distanceChaluteeField", distanceChaluteeField = new NumberEditor(this));
        
        distanceChaluteeField.setName("distanceChaluteeField");
        distanceChaluteeField.setProperty("distanceChalutee");
        distanceChaluteeField.setUseFloat(false);
        distanceChaluteeField.setShowReset(true);
    }

    protected void createDistanceChaluteeLabel() {
        $objectMap.put("distanceChaluteeLabel", distanceChaluteeLabel = new JLabel());
        
        distanceChaluteeLabel.setName("distanceChaluteeLabel");
        distanceChaluteeLabel.setText(_("tutti.label.fishingOperation.distanceChalutee"));
    }

    protected void createDureeField() {
        $objectMap.put("dureeField", dureeField = new JTextField());
        
        dureeField.setName("dureeField");
        dureeField.setColumns(15);
        dureeField.setEnabled(false);
    }

    protected void createDureeLabel() {
        $objectMap.put("dureeLabel", dureeLabel = new JLabel());
        
        dureeLabel.setName("dureeLabel");
        dureeLabel.setText(_("tutti.label.fishingOperation.duree"));
    }

    protected void createEnvironmentTab() {
        $objectMap.put("environmentTab", environmentTab = new TabInfo());
        
        environmentTab.setTitle(_("tutti.label.tab.fishingOperation.environment"));
    }

    protected void createEnvironmentTabContent() {
        $objectMap.put("environmentTabContent", environmentTabContent = new EnvironmentTabUI(this));
        
        environmentTabContent.setName("environmentTabContent");
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createFishingOperationInvalidRadio() {
        $objectMap.put("fishingOperationInvalidRadio", fishingOperationInvalidRadio = new JRadioButton());
        
        fishingOperationInvalidRadio.setName("fishingOperationInvalidRadio");
        fishingOperationInvalidRadio.setText(_("tutti.label.fishingOperation.fishingOperationInvalid"));
        fishingOperationInvalidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationInvalidRadio"));
    }

    protected void createFishingOperationNumberField() {
        $objectMap.put("fishingOperationNumberField", fishingOperationNumberField = new NumberEditor(this));
        
        fishingOperationNumberField.setName("fishingOperationNumberField");
        fishingOperationNumberField.setProperty("fishingOperationNumber");
        fishingOperationNumberField.setUseFloat(false);
        fishingOperationNumberField.setShowReset(true);
    }

    protected void createFishingOperationNumberLabel() {
        $objectMap.put("fishingOperationNumberLabel", fishingOperationNumberLabel = new JLabel());
        
        fishingOperationNumberLabel.setName("fishingOperationNumberLabel");
        fishingOperationNumberLabel.setText(_("tutti.label.fishingOperation.fishingOperationNumber"));
    }

    protected void createFishingOperationPane() {
        $objectMap.put("fishingOperationPane", fishingOperationPane = new JPanel());
        
        fishingOperationPane.setName("fishingOperationPane");
        fishingOperationPane.setLayout(new BorderLayout());
    }

    protected void createFishingOperationRectiligneCheckBox() {
        $objectMap.put("fishingOperationRectiligneCheckBox", fishingOperationRectiligneCheckBox = new JCheckBox());
        
        fishingOperationRectiligneCheckBox.setName("fishingOperationRectiligneCheckBox");
        fishingOperationRectiligneCheckBox.setText(_("tutti.label.fishingOperation.fishingOperationRectiligne"));
        fishingOperationRectiligneCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fishingOperationRectiligneCheckBox"));
    }

    protected void createFishingOperationResetRadio() {
        $objectMap.put("fishingOperationResetRadio", fishingOperationResetRadio = new JRadioButton());
        
        fishingOperationResetRadio.setName("fishingOperationResetRadio");
    }

    protected void createFishingOperationTabPane() {
        $objectMap.put("fishingOperationTabPane", fishingOperationTabPane = new JTabbedPane());
        
        fishingOperationTabPane.setName("fishingOperationTabPane");
    }

    protected void createFishingOperationValid() {
        $objectMap.put("fishingOperationValid", fishingOperationValid = new JAXXButtonGroup());
    }

    protected void createFishingOperationValidPanel() {
        $objectMap.put("fishingOperationValidPanel", fishingOperationValidPanel = new JToolBar());
        
        fishingOperationValidPanel.setName("fishingOperationValidPanel");
        fishingOperationValidPanel.setLayout(new BorderLayout());
        fishingOperationValidPanel.setFloatable(false);
        fishingOperationValidPanel.setOpaque(false);
        fishingOperationValidPanel.setBorderPainted(false);
    }

    protected void createFishingOperationValidRadio() {
        $objectMap.put("fishingOperationValidRadio", fishingOperationValidRadio = new JRadioButton());
        
        fishingOperationValidRadio.setName("fishingOperationValidRadio");
        fishingOperationValidRadio.setText(_("tutti.label.fishingOperation.fishingOperationValid"));
        fishingOperationValidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationValidRadio"));
    }

    protected void createGearCaracteristicsTable() {
        $objectMap.put("gearCaracteristicsTable", gearCaracteristicsTable = new Table());
        
        gearCaracteristicsTable.setName("gearCaracteristicsTable");
    }

    protected void createGearDateLabel() {
        $objectMap.put("gearDateLabel", gearDateLabel = new JLabel());
        
        gearDateLabel.setName("gearDateLabel");
        gearDateLabel.setText(_("tutti.label.fishingOperation.gearDate"));
    }

    protected void createGearLatitudeLabel() {
        $objectMap.put("gearLatitudeLabel", gearLatitudeLabel = new JLabel());
        
        gearLatitudeLabel.setName("gearLatitudeLabel");
        gearLatitudeLabel.setText(_("tutti.label.fishingOperation.gearLatitude"));
    }

    protected void createGearLongitudeLabel() {
        $objectMap.put("gearLongitudeLabel", gearLongitudeLabel = new JLabel());
        
        gearLongitudeLabel.setName("gearLongitudeLabel");
        gearLongitudeLabel.setText(_("tutti.label.fishingOperation.gearLongitude"));
    }

    protected void createGearShootingEndDateField() {
        $objectMap.put("gearShootingEndDateField", gearShootingEndDateField = new JXDatePicker());
        
        gearShootingEndDateField.setName("gearShootingEndDateField");
        gearShootingEndDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingEndDateField"));
    }

    protected void createGearShootingEndLabel() {
        $objectMap.put("gearShootingEndLabel", gearShootingEndLabel = new JLabel());
        
        gearShootingEndLabel.setName("gearShootingEndLabel");
        gearShootingEndLabel.setText(_("tutti.label.fishingOperation.gearShootingEnd"));
    }

    protected void createGearShootingEndLatitudeLabel() {
        $objectMap.put("gearShootingEndLatitudeLabel", gearShootingEndLatitudeLabel = new JTextField());
        
        gearShootingEndLatitudeLabel.setName("gearShootingEndLatitudeLabel");
        gearShootingEndLatitudeLabel.setColumns(15);
        gearShootingEndLatitudeLabel.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingEndLatitudeLabel"));
    }

    protected void createGearShootingEndLongitudeField() {
        $objectMap.put("gearShootingEndLongitudeField", gearShootingEndLongitudeField = new JTextField());
        
        gearShootingEndLongitudeField.setName("gearShootingEndLongitudeField");
        gearShootingEndLongitudeField.setColumns(15);
        gearShootingEndLongitudeField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingEndLongitudeField"));
    }

    protected void createGearShootingEndTimeField() {
        $objectMap.put("gearShootingEndTimeField", gearShootingEndTimeField = new SimpleTimeEditor(this));
        
        gearShootingEndTimeField.setName("gearShootingEndTimeField");
        gearShootingEndTimeField.setProperty("gearShootingEndDate");
    }

    protected void createGearShootingStartDateField() {
        $objectMap.put("gearShootingStartDateField", gearShootingStartDateField = new JXDatePicker());
        
        gearShootingStartDateField.setName("gearShootingStartDateField");
        gearShootingStartDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingStartDateField"));
    }

    protected void createGearShootingStartLabel() {
        $objectMap.put("gearShootingStartLabel", gearShootingStartLabel = new JLabel());
        
        gearShootingStartLabel.setName("gearShootingStartLabel");
        gearShootingStartLabel.setText(_("tutti.label.fishingOperation.gearShootingStart"));
    }

    protected void createGearShootingStartLatitudeLabel() {
        $objectMap.put("gearShootingStartLatitudeLabel", gearShootingStartLatitudeLabel = new JTextField());
        
        gearShootingStartLatitudeLabel.setName("gearShootingStartLatitudeLabel");
        gearShootingStartLatitudeLabel.setColumns(15);
        gearShootingStartLatitudeLabel.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingStartLatitudeLabel"));
    }

    protected void createGearShootingStartLongitudeField() {
        $objectMap.put("gearShootingStartLongitudeField", gearShootingStartLongitudeField = new JTextField());
        
        gearShootingStartLongitudeField.setName("gearShootingStartLongitudeField");
        gearShootingStartLongitudeField.setColumns(15);
        gearShootingStartLongitudeField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__gearShootingStartLongitudeField"));
    }

    protected void createGearShootingStartTimeField() {
        $objectMap.put("gearShootingStartTimeField", gearShootingStartTimeField = new SimpleTimeEditor(this));
        
        gearShootingStartTimeField.setName("gearShootingStartTimeField");
        gearShootingStartTimeField.setProperty("gearShootingStartDate");
    }

    protected void createGearShootingTabContent() {
        $objectMap.put("gearShootingTabContent", gearShootingTabContent = new GearShootingTabUI(this));
        
        gearShootingTabContent.setName("gearShootingTabContent");
    }

    protected void createGearTimeLabel() {
        $objectMap.put("gearTimeLabel", gearTimeLabel = new JLabel());
        
        gearTimeLabel.setName("gearTimeLabel");
        gearTimeLabel.setText(_("tutti.label.fishingOperation.gearTime"));
    }

    protected void createGeneralForm() {
        $objectMap.put("generalForm", generalForm = new Table());
        
        generalForm.setName("generalForm");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditFishingOperationUIHandler.class));
    }

    protected void createHydrologyTabContent() {
        $objectMap.put("hydrologyTabContent", hydrologyTabContent = new HydrologyTabUI(this));
        
        hydrologyTabContent.setName("hydrologyTabContent");
    }

    protected void createImportCasinoButton() {
        $objectMap.put("importCasinoButton", importCasinoButton = new JButton());
        
        importCasinoButton.setName("importCasinoButton");
        importCasinoButton.setText(_("tutti.action.casino-import"));
        importCasinoButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importCasinoButton"));
    }

    protected void createLocationComboBox() {
        $objectMap.put("locationComboBox", locationComboBox = new BeanComboBox<FishingOperationLocation>(this));
        
        locationComboBox.setName("locationComboBox");
        locationComboBox.setI18nPrefix("tutti.property.");
        locationComboBox.setProperty("location");
        locationComboBox.setShowReset(true);
    }

    protected void createLocationLabel() {
        $objectMap.put("locationLabel", locationLabel = new JLabel());
        
        locationLabel.setName("locationLabel");
        locationLabel.setText(_("tutti.label.fishingOperation.location"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditFishingOperationUIModel.class));
    }

    protected void createNoTraitPane() {
        $objectMap.put("noTraitPane", noTraitPane = new JLabel());
        
        noTraitPane.setName("noTraitPane");
        noTraitPane.setText(_("tutti.label.no.fishingOperation.selected"));
    }

    protected void createResetValidStateButton() {
        $objectMap.put("resetValidStateButton", resetValidStateButton = new JButton());
        
        resetValidStateButton.setName("resetValidStateButton");
        resetValidStateButton.setText(_("tutti.action.reset.fishingOperationValidState"));
        resetValidStateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetValidStateButton"));
    }

    protected void createSaisisseurList() {
        $objectMap.put("saisisseurList", saisisseurList = new BeanDoubleList<Person>());
        
        saisisseurList.setName("saisisseurList");
        saisisseurList.setProperty("saisisseur");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.save"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createStationNumberField() {
        $objectMap.put("stationNumberField", stationNumberField = new JTextField());
        
        stationNumberField.setName("stationNumberField");
        stationNumberField.setColumns(15);
        stationNumberField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__stationNumberField"));
    }

    protected void createStationNumberLabel() {
        $objectMap.put("stationNumberLabel", stationNumberLabel = new JLabel());
        
        stationNumberLabel.setName("stationNumberLabel");
        stationNumberLabel.setText(_("tutti.label.fishingOperation.stationNumber"));
    }

    protected void createStrataComboBox() {
        $objectMap.put("strataComboBox", strataComboBox = new BeanComboBox<FishingOperationLocation>(this));
        
        strataComboBox.setName("strataComboBox");
        strataComboBox.setI18nPrefix("tutti.property.");
        strataComboBox.setProperty("strata");
        strataComboBox.setShowReset(true);
    }

    protected void createStrataLabel() {
        $objectMap.put("strataLabel", strataLabel = new JLabel());
        
        strataLabel.setName("strataLabel");
        strataLabel.setText(_("tutti.label.fishingOperation.strata"));
    }

    protected void createSubStrataComboBox() {
        $objectMap.put("subStrataComboBox", subStrataComboBox = new BeanComboBox<FishingOperationLocation>(this));
        
        subStrataComboBox.setName("subStrataComboBox");
        subStrataComboBox.setI18nPrefix("tutti.property.");
        subStrataComboBox.setProperty("subStrata");
        subStrataComboBox.setShowReset(true);
    }

    protected void createSubStrataLabel() {
        $objectMap.put("subStrataLabel", subStrataLabel = new JLabel());
        
        subStrataLabel.setName("subStrataLabel");
        subStrataLabel.setText(_("tutti.label.fishingOperation.subStrata"));
    }

    protected void createTraitGearShootingTab() {
        $objectMap.put("traitGearShootingTab", traitGearShootingTab = new TabInfo());
        
        traitGearShootingTab.setTitle(_("tutti.label.tab.fishingOperation.gearShooting"));
    }

    protected void createTraitGeneralTab() {
        $objectMap.put("traitGeneralTab", traitGeneralTab = new TabInfo());
        
        traitGeneralTab.setTitle(_("tutti.label.tab.fishingOperation.general"));
    }

    protected void createTraitHydrologyTabContent() {
        $objectMap.put("traitHydrologyTabContent", traitHydrologyTabContent = new TabInfo());
        
        traitHydrologyTabContent.setTitle(_("tutti.label.tab.fishingOperation.hydrology"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditFishingOperationUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToFishingOperationPane();
        addChildrenToFishingOperationTabPane();
        addChildrenToGeneralForm();
        // inline complete setup of $JPanel0
        $JPanel0.add(gearCaracteristicsTable, BorderLayout.CENTER);
        addChildrenToGearCaracteristicsTable();
        addChildrenToFishingOperationValidPanel();
        addChildrenToFishingOperationResetRadio();
        // inline complete setup of $HBox0
        $HBox0.add(fishingOperationValidRadio);
        $HBox0.add(fishingOperationInvalidRadio);
        addChildrenToFishingOperationValidRadio();
        addChildrenToFishingOperationInvalidRadio();
        // inline complete setup of $JPanel2
        $JPanel2.add(distanceChaluteeLabel, BorderLayout.WEST);
        $JPanel2.add(distanceChaluteeField, BorderLayout.CENTER);
        // inline complete setup of $JPanel3
        $JPanel3.add(importCasinoButton);
        addChildrenToCommentPane();
        // inline complete setup of $JPanel4
        $JPanel4.add(createFishingOperationActions, BorderLayout.CENTER);
        addChildrenToCreateFishingOperationActions();
        
        // apply 24 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 43 property setters
        strataComboBox.setBeanType(FishingOperationLocation.class);
        subStrataComboBox.setBeanType(FishingOperationLocation.class);
        locationComboBox.setBeanType(FishingOperationLocation.class);
        saisisseurList.setBeanType(Person.class);
        stationNumberLabel.setLabelFor(stationNumberField);
        fishingOperationNumberLabel.setLabelFor(fishingOperationNumberField);
        fishingOperationNumberField.setBean(model);
        fishingOperationNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        fishingOperationNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        dateLabel.setLabelFor(dateField);
        dateField.setFormats("dd/MM/yyyy");
        strataLabel.setLabelFor(strataComboBox);
        strataComboBox.setBean(model);
        subStrataLabel.setLabelFor(subStrataComboBox);
        subStrataComboBox.setBean(model);
        locationLabel.setLabelFor(locationComboBox);
        locationComboBox.setBean(model);
        gearShootingStartDateField.setFormats("dd/MM/yyyy");
        gearShootingStartTimeField.setBean(model);
        gearShootingEndDateField.setFormats("dd/MM/yyyy");
        gearShootingEndTimeField.setBean(model);
        resetValidStateButton.setIcon(SwingUtil.createActionIcon("reset"));
        distanceChaluteeLabel.setLabelFor(distanceChaluteeField);
        distanceChaluteeField.setBean(model);
        distanceChaluteeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        distanceChaluteeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        dureeLabel.setLabelFor(dureeField);
        importCasinoButton.setIcon(SwingUtil.createActionIcon("casino-import"));
        saisisseurList.setBean(model);
        saisisseurList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.list.saisisseur")));
        commentPane.setColumnHeaderView(new JLabel(_("tutti.label.comment")));
        commentPane.setMinimumSize(new Dimension(10,50));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        noTraitPane.setHorizontalAlignment(JLabel.CENTER);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createFishingOperationPane();
        createFishingOperationTabPane();
        createGeneralForm();
        createStationNumberLabel();
        createStationNumberField();
        createFishingOperationNumberLabel();
        createFishingOperationNumberField();
        createDateLabel();
        createDateField();
        createStrataLabel();
        createStrataComboBox();
        createSubStrataLabel();
        createSubStrataComboBox();
        createLocationLabel();
        createLocationComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createGearCaracteristicsTable();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createGearLatitudeLabel();
        createGearLongitudeLabel();
        createGearDateLabel();
        createGearTimeLabel();
        createGearShootingStartLabel();
        createGearShootingStartLatitudeLabel();
        createGearShootingStartLongitudeField();
        createGearShootingStartDateField();
        createGearShootingStartTimeField();
        createGearShootingEndLabel();
        createGearShootingEndLatitudeLabel();
        createGearShootingEndLongitudeField();
        createGearShootingEndDateField();
        createGearShootingEndTimeField();
        createFishingOperationValidPanel();
        createResetValidStateButton();
        createFishingOperationResetRadio();
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        createFishingOperationValidRadio();
        createFishingOperationInvalidRadio();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createFishingOperationRectiligneCheckBox();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        createDistanceChaluteeLabel();
        createDistanceChaluteeField();
        createDureeLabel();
        createDureeField();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createImportCasinoButton();
        createSaisisseurList();
        createCommentPane();
        createCommentField();
        createGearShootingTabContent();
        createEnvironmentTabContent();
        createHydrologyTabContent();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new BorderLayout());
        createCreateFishingOperationActions();
        createCancelButton();
        createSaveButton();
        createNoTraitPane();
        createTraitGeneralTab();
        createTraitGearShootingTab();
        createEnvironmentTab();
        createTraitHydrologyTabContent();
        createFishingOperationValid();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 24 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 24 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATION_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("stationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(stationNumberField, model.getStationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("stationNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationNumberField.setModel(model.getFishingOperationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationNumber", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                fishingOperationNumberField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("date", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dateField.setDate(model.getDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("date", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("strata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    strataComboBox.setSelectedItem(model.getStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("strata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("subStrata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    subStrataComboBox.setSelectedItem(model.getSubStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("subStrata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LOCATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("location", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    locationComboBox.setSelectedItem(model.getLocation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("location", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(gearShootingStartLongitudeField, getStringValue(model.getGearShootingStartLongitude()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartDateField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartTimeField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(gearShootingEndLongitudeField, getStringValue(model.getGearShootingEndLongitude()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndDateField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndTimeField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationResetRadio.setSelected(model.getFishingOperationValid() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationValidRadio.setSelected(model.getFishingOperationValid() == Boolean.TRUE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationInvalidRadio.setSelected(model.getFishingOperationValid() == Boolean.FALSE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationRectiligneCheckBox.setSelected(model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISTANCE_CHALUTEE_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    distanceChaluteeField.setEnabled(!model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISTANCE_CHALUTEE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("distanceChalutee", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    distanceChaluteeField.setModel(model.getDistanceChalutee());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("distanceChalutee", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DISTANCE_CHALUTEE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                distanceChaluteeField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DUREE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("duree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(dureeField, getStringValue(model.getDuree()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("duree", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_FISHING_OPERATION_ACTIONS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("persisted", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createFishingOperationActions.setVisible(!model.isPersisted());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("persisted", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}