/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.campaign;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CampaignBean;
import fr.ifremer.tutti.persistence.entities.SurveyBean;
import fr.ifremer.tutti.persistence.entities.TuttiBeans;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.campaign.SelectCampaignUI;
import fr.ifremer.tutti.ui.swing.content.campaign.SelectCampaignUIModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectCampaignUIHandler
extends AbstractTuttiUIHandler<SelectCampaignUIModel> {
    private static final Log log = LogFactory.getLog(SelectCampaignUIHandler.class);
    protected final PersistenceService persistenceService;
    protected final SelectCampaignUI ui;

    public SelectCampaignUIHandler(TuttiUIContext context, SelectCampaignUI ui) {
        super(context);
        this.ui = ui;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    protected SelectCampaignUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    public void beforeInitUI() {
        SelectCampaignUIModel model = new SelectCampaignUIModel();
        List allSurveys = this.persistenceService.getAllSurveys();
        model.setSurveys(allSurveys);
        if (!allSurveys.isEmpty()) {
            String surveyId = this.context.getSurveyId();
            SurveyBean selectedSurvey = null;
            List allCampaigns = null;
            if (surveyId != null) {
                selectedSurvey = (SurveyBean)TuttiBeans.findById((Collection)allSurveys, (String)surveyId);
                allCampaigns = this.persistenceService.getAllCampaigns(surveyId);
            }
            model.setSurvey(selectedSurvey);
            model.setCampaigns(allCampaigns);
            if (!CollectionUtils.isEmpty(allCampaigns)) {
                String campaignId = this.context.getCampaignId();
                CampaignBean selectedCampaign = null;
                if (campaignId != null) {
                    selectedCampaign = (CampaignBean)TuttiBeans.findById((Collection)allCampaigns, (String)campaignId);
                }
                model.setCampaign(selectedCampaign);
            }
        }
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        SelectCampaignUIModel model = this.ui.getModel();
        this.initBeanComboBox(this.ui.getSurveyCombobox(), model.getSurveys(), model.getSurvey());
        this.initBeanComboBox(this.ui.getCampaignCombobox(), model.getCampaigns(), model.getCampaign());
        model.addPropertyChangeListener("survey", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SurveyBean newValue = (SurveyBean)evt.getNewValue();
                boolean noSurvey = newValue == null;
                SelectCampaignUIHandler.this.context.setSurveyId(noSurvey ? null : newValue.getId());
                List campaigns = noSurvey ? Lists.newArrayList() : SelectCampaignUIHandler.this.persistenceService.getAllCampaigns(newValue.getId());
                SelectCampaignUIModel model = (SelectCampaignUIModel)((Object)evt.getSource());
                model.setCampaigns(campaigns);
                model.setCampaign(null);
            }
        });
        model.addPropertyChangeListener("campaigns", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BeanComboBox<CampaignBean> combobox = SelectCampaignUIHandler.this.ui.getCampaignCombobox();
                List campaigns = (List)evt.getNewValue();
                combobox.setData(null);
                combobox.setData(campaigns);
            }
        });
        model.addPropertyChangeListener("campaign", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CampaignBean newValue = (CampaignBean)evt.getNewValue();
                SelectCampaignUIHandler.this.context.setCampaignId(newValue == null ? null : newValue.getId());
            }
        });
    }

    @Override
    public void onCloseUI() {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener listener : listeners = this.ui.getModel().getPropertyChangeListeners()) {
            this.getModel().removePropertyChangeListener(listener);
        }
    }

    public void showCatches() {
        this.context.setScreen(TuttiScreen.FILL_CATCHES);
    }

    public void showSelectedSurvey() {
        SurveyBean survey = this.getModel().getSurvey();
        this.context.setSurveyId(survey.getId());
        this.context.setScreen(TuttiScreen.EDIT_SURVEY);
    }

    public void showNewSurvey() {
        this.context.setSurveyId(null);
        this.context.setCampaignId(null);
        this.context.setScreen(TuttiScreen.EDIT_SURVEY);
    }

    public void showSelectedCampaign() {
        CampaignBean campaign = this.getModel().getCampaign();
        this.context.setCampaignId(campaign.getId());
        this.context.setScreen(TuttiScreen.EDIT_CAMPAIGN);
    }

    public void showNewCampaign() {
        this.context.setCampaignId(null);
        this.context.setScreen(TuttiScreen.EDIT_CAMPAIGN);
    }
}

