/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.campaign;

import fr.ifremer.tutti.persistence.entities.CampaignBean;
import fr.ifremer.tutti.persistence.entities.SurveyBean;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.campaign.EditCampaignUI;
import fr.ifremer.tutti.ui.swing.content.campaign.EditCampaignUIModel;
import java.util.List;
import javax.swing.JTable;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditCampaignUIHandler
extends AbstractTuttiUIHandler<EditCampaignUIModel> {
    private final EditCampaignUI ui;
    private final PersistenceService persistenceService;

    public EditCampaignUIHandler(TuttiUIContext context, EditCampaignUI ui) {
        super(context);
        this.ui = ui;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        EditCampaignUIModel model = new EditCampaignUIModel();
        String campaignId = this.context.getCampaignId();
        if (campaignId == null) {
            SurveyBean survey = this.persistenceService.getSurvey(this.context.getSurveyId());
            model.setSurvey(survey);
        } else {
            CampaignBean campaign = this.persistenceService.getCampaign(campaignId);
            model.fromBean(campaign);
        }
        this.listModelIsModify(model);
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        List users = this.persistenceService.getAllUsers();
        EditCampaignUIModel model = this.ui.getModel();
        this.initBeanComboBox(this.ui.getSurveyComboBox(), this.persistenceService.getAllSurveys(), model.getSurvey());
        this.initBeanComboBox(this.ui.getCountryComboBox(), this.persistenceService.getAllCountries(), model.getCountry());
        this.initBeanList(this.ui.getVesselHeader(), this.persistenceService.getAllVessels(), model.getVessel());
        this.initBeanList(this.ui.getGearHeader(), this.persistenceService.getAllGears(), model.getGear());
        this.initBeanList(this.ui.getHeadOfMissionHeader(), users, model.getHeadOfMission());
        this.initBeanList(this.ui.getHeadOfSortRoomHeader(), users, model.getHeadOfSortRoom());
        SwingValidatorUtil.installUI((JTable)this.ui.getErrorTable(), (SwingValidatorMessageTableRenderer)new SwingValidatorMessageTableRenderer());
        this.listenValidatorValid((SimpleBeanValidator)this.ui.getValidator(), model);
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    protected EditCampaignUIModel getModel() {
        return this.ui.getModel();
    }

    public void cancel() {
        this.context.setScreen(TuttiScreen.SELECT_CAMPAIGN);
    }

    public void save() {
        EditCampaignUIModel model = this.ui.getModel();
        CampaignBean bean = model.toBean();
        CampaignBean saved = model.isCreate() ? this.persistenceService.createCampaign(bean) : this.persistenceService.saveCampaign(bean);
        this.context.setSurveyId(saved.getSurvey().getId());
        this.context.setCampaignId(saved.getId());
        this.context.setScreen(TuttiScreen.SELECT_CAMPAIGN);
    }

    public void importCasino() {
    }
}

