/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.AbstractTuttiBean;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.TuttiServiceTechnicalException;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiConfig;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import jaxx.runtime.swing.OneClicListSelectionModel;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.TimeEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.swing.renderer.DecoratorTableCellRenderer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.util.decorator.JXPathDecorator;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public abstract class AbstractTuttiUIHandler<M> {
    private static final Log log = LogFactory.getLog(AbstractTuttiUIHandler.class);
    protected final TuttiUIContext context;

    public abstract void beforeInitUI();

    public abstract void afterInitUI();

    public abstract void onCloseUI();

    protected abstract M getModel();

    protected AbstractTuttiUIHandler(TuttiUIContext context) {
        this.context = context;
    }

    public TuttiUIContext getContext() {
        return this.context;
    }

    public TuttiConfig getConfig() {
        return this.context.getConfig();
    }

    public void setText(KeyEvent event, String property) {
        JTextComponent field = (JTextComponent)event.getSource();
        String value = field.getText();
        this.setProperty(this.getModel(), property, value);
    }

    public void setBoolean(ItemEvent event, String property) {
        boolean value = event.getStateChange() == 1;
        this.setProperty(this.getModel(), property, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectListData(ListSelectionEvent event, String property) {
        if (!event.getValueIsAdjusting()) {
            JList list = (JList)event.getSource();
            ListSelectionModel selectionModel = list.getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                LinkedList selectedList = Lists.newLinkedList();
                for (int index : list.getSelectedIndices()) {
                    Object o = list.getModel().getElementAt(index);
                    selectedList.add(o);
                }
                this.setProperty(this.getModel(), property, selectedList);
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    protected void setProperty(Object bean, String property, Object value) {
        try {
            PropertyUtils.setSimpleProperty((Object)bean, (String)property, (Object)value);
        }
        catch (Exception e) {
            throw new TuttiServiceTechnicalException("Could not set property", (Throwable)e);
        }
    }

    protected void initUI(TuttiUI ui) {
        for (Map.Entry entry : ui.get$objectMap().entrySet()) {
            Object component = entry.getValue();
            if (component instanceof NumberEditor) {
                this.initNumberEditor((NumberEditor)component);
                continue;
            }
            if (component instanceof JXDatePicker) {
                this.initDatePicker((JXDatePicker)component);
                continue;
            }
            if (!(component instanceof TimeEditor)) continue;
            this.initTimeEditor((TimeEditor)component);
        }
    }

    protected <E extends AbstractTuttiBean> void initBeanComboBox(BeanComboBox<E> comboBox, List<E> data, E selectedData) {
        Class beanType = comboBox.getHandler().getTargetClass();
        DecoratorService decoratorService = this.context.getService(DecoratorService.class);
        Decorator decorator = decoratorService.getDecoratorByType(beanType);
        if (log.isInfoEnabled()) {
            log.info((Object)("entity list [" + beanType.getName() + "] : " + (data == null ? 0 : data.size())));
        }
        comboBox.init((JXPathDecorator)decorator, data);
        comboBox.setSelectedItem(selectedData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("combo [" + beanType.getName() + "] : " + comboBox.getData().size()));
        }
    }

    protected <E extends AbstractTuttiBean> void initBeanList(BeanListHeader<E> listHeader, List<E> data, List<E> selectedData) {
        Class beanType = listHeader.getBeanType();
        DecoratorService decoratorService = this.context.getService(DecoratorService.class);
        Decorator decorator = decoratorService.getDecoratorByType(beanType);
        if (log.isInfoEnabled()) {
            log.info((Object)("entity list [" + beanType.getName() + "] : " + (data == null ? 0 : data.size())));
        }
        listHeader.init((JXPathDecorator)decorator, data);
        OneClicListSelectionModel.installModel((JList)listHeader.getList());
        this.updateIndices(listHeader.getList(), selectedData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Jlist [" + beanType.getName() + "] : " + listHeader.getData().size()));
        }
    }

    protected void initNumberEditor(NumberEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init number editor " + editor.getName()));
        }
        editor.init();
    }

    protected void initTimeEditor(TimeEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init time editor " + editor.getName() + " for property " + editor.getProperty()));
        }
        editor.init();
    }

    protected void initDatePicker(JXDatePicker picker) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("disable JXDatePicker editor" + picker.getName()));
        }
        picker.getEditor().setEditable(false);
    }

    protected <B extends AbstractTuttiBean> void updateIndices(JList<B> jlist, List<B> list) {
        int i;
        List ids = list == null ? Collections.emptyList() : Lists.transform(list, (Function)new Function<B, String>(){

            public String apply(B input) {
                return input.getId();
            }
        });
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (list != null && !list.isEmpty()) {
            ListModel<B> model = jlist.getModel();
            int max = model.getSize();
            for (i = 0; i < max; ++i) {
                AbstractTuttiBean s = (AbstractTuttiBean)model.getElementAt(i);
                if (!ids.contains(s.getId())) continue;
                indices.add(i);
            }
        }
        int[] result = new int[indices.size()];
        i = 0;
        for (Integer indice : indices) {
            result[i++] = indice;
        }
        indices.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected indices : " + Arrays.toString(result)));
        }
        jlist.setSelectedIndices(result);
    }

    protected <O> ListCellRenderer newListCellRender(Class<O> type) {
        DecoratorService decoratorService = this.context.getService(DecoratorService.class);
        Preconditions.checkNotNull(type);
        Decorator decorator = decoratorService.getDecoratorByType(type);
        Preconditions.checkNotNull((Object)decorator);
        DecoratorListCellRenderer result = new DecoratorListCellRenderer(decorator);
        return result;
    }

    protected <O> TableCellRenderer newTableCellRender(Class<O> type) {
        DecoratorService decoratorService = this.context.getService(DecoratorService.class);
        Preconditions.checkNotNull(type);
        Decorator decorator = decoratorService.getDecoratorByType(type);
        Preconditions.checkNotNull((Object)decorator);
        DecoratorTableCellRenderer result = new DecoratorTableCellRenderer(decorator);
        return result;
    }

    protected void listenValidatorValid(SimpleBeanValidator validator, final AbstractTuttiBeanUIModel model) {
        validator.addPropertyChangeListener("valid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                model.setValid((Boolean)evt.getNewValue());
            }
        });
    }

    protected void listModelIsModify(AbstractTuttiBeanUIModel model) {
        model.addPropertyChangeListener(new PropertyChangeListener(){
            final Set<String> excludeProperties = Sets.newHashSet((Object[])new String[]{"modify", "valid"});

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!this.excludeProperties.contains(evt.getPropertyName())) {
                    ((AbstractTuttiBeanUIModel)((Object)evt.getSource())).setModify(true);
                }
            }
        });
    }
}

