/*
 * Decompiled with CFR 0.152.
 */
package sensitivityexports;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.io.File;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.util.ReverseFileReader;
import scripts.ResultName;

public class SensitivityBiomassRelativeReferenceY12
implements SensitivityExport {
    private static Log log = LogFactory.getLog(SensitivityBiomassRelativeReferenceY12.class);
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_BIOMASS};
    @Doc(value="Population")
    public Population param_pop;
    @Doc(value="URL of the Biomasses.csv reference export file")
    public String param_referenceBiomassCSV = "";

    public void export(SimulationStorage simulation, Writer out) throws Exception {
        ResultStorage resultStorage = simulation.getResultStorage();
        TimeStep lastStep = resultStorage.getLastStep();
        TimeStep firstStep = new TimeStep(11);
        double biomass = 0.0;
        double firstBiomass = 0.0;
        double biomassReference = 0.0;
        double firstBiomassReference = 0.0;
        File referenceFile = new File(this.param_referenceBiomassCSV);
        ReverseFileReader reader = new ReverseFileReader(referenceFile);
        reader.readLine();
        String line = reader.readLine();
        String lastMonth = "";
        while (line != null) {
            String[] items = line.split(";");
            if ("".equals(lastMonth)) {
                lastMonth = items[3];
            }
            if (items[0].equals(this.param_pop.getName()) && items[3].equals(lastMonth)) {
                biomassReference += Double.parseDouble(items[4]);
            }
            if (items[0].equals(this.param_pop.getName()) && items[3].equals("11")) {
                firstBiomassReference += Double.parseDouble(items[4]);
            }
            line = reader.readLine();
        }
        for (Population pop : simulation.getParameter().getPopulations()) {
            if (!pop.getName().equals(this.param_pop.getName())) continue;
            MatrixND matfirstdate = resultStorage.getMatrix(firstStep, pop, ResultName.MATRIX_BIOMASS);
            firstBiomass = matfirstdate.sumAll();
            MatrixND matlastdate = resultStorage.getMatrix(lastStep, pop, ResultName.MATRIX_BIOMASS);
            biomass = matlastdate.sumAll();
        }
        out.write(Double.toString(biomass / firstBiomass / (biomassReference / firstBiomassReference)));
    }

    public String getDescription() {
        return "Biomass for the last time step. Biomass is the sum on the groups and zones";
    }

    public String getExportFilename() {
        return "SensitivityBiomassRelativeReferenceY12_" + this.param_pop.getName();
    }

    public String getExtensionFilename() {
        return ".csv";
    }

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }
}

