/*
 * Decompiled with CFR 0.152.
 */
package rules;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.rule.AbstractRule;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;
import scripts.SiMatrix;

public class GraviteVPUE1
extends AbstractRule {
    private static Log log = LogFactory.getLog(GraviteVPUE1.class);
    protected MatrixND SommePropInitial = null;
    protected MatrixND valuePerUnitOfEffort = null;
    protected boolean first = true;
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_GROSS_VALUE_OF_LANDINGS_PER_STRATEGY_MET, ResultName.MATRIX_EFFORT_NOMINAL_PER_STRATEGY_MET};
    private MapFunction nanFunction = new MapFunction(){

        public double apply(double value) {
            return Double.NaN;
        }
    };

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getDescription() throws Exception {
        return "Calcule les proportion par m\u00e9tier chaque mois en fonction de la VPUE du m\u00e9tier l'ann\u00e9e pr\u00e9c\u00e9dante";
    }

    public void init(SimulationContext context) throws Exception {
        TimeStep step = new TimeStep(0);
        List<Strategy> strs = SiMatrix.getSiMatrix(context).getStrategies(step);
        List<Metier> metiers = SiMatrix.getSiMatrix(context).getMetiers(step);
        List<Month> months = Arrays.asList(Month.MONTH);
        this.SommePropInitial = MatrixFactory.getInstance().create("SommePropInitial", new List[]{strs, months}, new String[]{"Strategies", "Months"});
        this.SommePropInitial.map(this.nanFunction);
        this.valuePerUnitOfEffort = MatrixFactory.getInstance().create("ValuePerUnitOfEffort", new List[]{strs, metiers}, new String[]{"Strategies", "Metiers"});
        this.valuePerUnitOfEffort.map(this.nanFunction);
        for (Strategy str : strs) {
            List<Metier> strMetiers = SiMatrix.getSiMatrix(context).getMetiers(str, step);
            List infos = str.getStrategyMonthInfo();
            for (StrategyMonthInfo info : infos) {
                double somme = 0.0;
                for (Metier strMetier : strMetiers) {
                    somme += info.getProportionMetier(strMetier);
                }
                this.SommePropInitial.setValue((Object)str, (Object)info.getMonth(), somme);
            }
        }
    }

    public boolean condition(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        return step.getYear() > 0;
    }

    public void preAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("first = " + this.first + "step:" + step));
        }
        if (this.first) {
            List<Strategy> strs = SiMatrix.getSiMatrix(context).getStrategies(step);
            ResultStorage resultmanager = context.getSimulationStorage().getResultStorage();
            MatrixND EffortNominalPerStrMet = resultmanager.getMatrix(step.previousYear(), ResultName.MATRIX_EFFORT_NOMINAL_PER_STRATEGY_MET);
            MatrixND GrossValuePerStrMet = resultmanager.getMatrix(step.previousYear(), ResultName.MATRIX_GROSS_VALUE_OF_LANDINGS_PER_STRATEGY_MET);
            this.valuePerUnitOfEffort.map(this.nanFunction);
            for (Strategy str : strs) {
                StrategyMonthInfo smi = str.getStrategyMonthInfo(step.getMonth());
                Collection strMet = str.getSetOfVessels().getPossibleMetiers();
                boolean testCondition = false;
                double somme = 0.0;
                for (EffortDescription ed : strMet) {
                    Metier strMetier = ed.getPossibleMetiers();
                    double effort = EffortNominalPerStrMet.getValue((Object)str, (Object)strMetier);
                    if (effort > 0.0) {
                        double value = GrossValuePerStrMet.getValue((Object)str, (Object)strMetier);
                        double vpue = value / effort;
                        this.valuePerUnitOfEffort.setValue((Object)str, (Object)strMetier, vpue);
                        somme += value / effort;
                        continue;
                    }
                    if (effort == 0.0 && smi.getProportionMetier(strMetier) == 0.0) {
                        this.valuePerUnitOfEffort.setValue((Object)str, (Object)strMetier, 0.0);
                        continue;
                    }
                    testCondition = true;
                }
                if (testCondition) continue;
                double SommeVPUEstrat = somme;
                for (EffortDescription ed : strMet) {
                    Metier strMetier = ed.getPossibleMetiers();
                    double newProp = SommeVPUEstrat == 0.0 ? 0.0 : this.SommePropInitial.getValue((Object)str, (Object)step.getMonth()) * this.valuePerUnitOfEffort.getValue((Object)str, (Object)strMetier) / SommeVPUEstrat;
                    smi.setProportionMetier(strMetier, newProp);
                }
            }
            this.first = false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"fin Gravite CPUEAction avant");
        }
    }

    public void postAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        this.first = true;
    }
}

