/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.data.Mooring;
import fr.ifremer.echobase.services.service.UserDbPersistenceService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class GetDataProcessingsForMooring
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected String entityId;
    protected Map<String, String> dataProcessings;
    @Inject
    protected transient UserDbPersistenceService userDbPersistenceService;

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public Map<String, String> getDataProcessings() {
        return this.dataProcessings;
    }

    public String execute() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.entityId)) {
            this.dataProcessings = Maps.newLinkedHashMap();
        } else {
            Mooring mooring = this.userDbPersistenceService.getMooring(this.entityId);
            Preconditions.checkNotNull((Object)mooring, (Object)("Could not find voyage with id " + this.entityId));
            this.dataProcessings = this.userDbPersistenceService.getDataProcessings(mooring);
        }
        return "success";
    }
}

