/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.echobase.services.EchoBaseService;
import fr.ifremer.echobase.services.EchoBaseServiceContext;
import fr.ifremer.echobase.ui.EchoBaseApplicationContext;
import fr.ifremer.echobase.ui.EchoBaseSession;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.web.struts2.BaseAction;

public class EchoBaseActionSupport
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private static final SimpleDateFormat monthFormat = new SimpleDateFormat("mm-yyyy");
    @Inject
    private transient EchoBaseApplicationContext applicationContext;
    @Inject
    private transient EchoBaseSession echoBaseSession;
    @Inject
    private transient EchoBaseServiceContext serviceContext;

    protected <E extends EchoBaseService> E newService(Class<E> serviceClass) {
        EchoBaseService service = this.getServiceContext().newService(serviceClass);
        return (E)service;
    }

    public String formatDate(Date date) {
        String result = dateFormat.format(date);
        return result;
    }

    public String formatMonth(Date date) {
        String result = monthFormat.format(date);
        return result;
    }

    public void addFlashMessage(String message) {
        this.getEchoBaseSession().addMessage("messages", message);
    }

    public void addFlashError(String message) {
        this.getEchoBaseSession().addMessage("errors", message);
    }

    public void addFlashWarning(String message) {
        this.getEchoBaseSession().addMessage("warnings", message);
    }

    public String getDocumentation(String page) {
        return this.getDocumentation(page, null);
    }

    public String getDocumentation(String page, String anchor) {
        Locale locale = this.getLocale();
        String result = this.getEchoBaseApplicationContext().getConfiguration().getDocumentationUrl().toString();
        if (!result.endsWith("/")) {
            result = result + "/";
        }
        if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
            result = result + "en/";
        }
        result = result + page;
        if (StringUtils.isNotBlank((CharSequence)anchor)) {
            result = result + "#" + anchor;
        }
        return result;
    }

    public EchoBaseApplicationContext getEchoBaseApplicationContext() {
        Preconditions.checkNotNull((Object)("No applicationContext is your action " + this));
        return this.applicationContext;
    }

    public EchoBaseSession getEchoBaseSession() {
        Preconditions.checkNotNull((Object)("No echoBaseSession is your action " + this));
        return this.echoBaseSession;
    }

    public EchoBaseServiceContext getServiceContext() {
        Preconditions.checkNotNull((Object)("No serviceContext is your action " + this));
        return this.serviceContext;
    }
}

