/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.workingDb;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.DriverType;
import fr.ifremer.echobase.persistence.EchoBaseEntityHelper;
import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.ui.actions.workingDb.AbstractWorkingDbAction;
import java.sql.SQLException;

public class CreatePostgresDb
extends AbstractWorkingDbAction {
    private static final long serialVersionUID = 1L;
    protected String login;
    protected String password;
    protected JdbcConfiguration jdbcConf;
    protected JdbcConfiguration metaJdbcConf;

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InputConfig(methodName="input")
    public String execute() throws Exception {
        EchoBaseEntityHelper.checkJDBCConnection((JdbcConfiguration)this.metaJdbcConf);
        try {
            this.getEchoBaseSession().initWorkingDb(this.metaJdbcConf, false);
            this.workingDbConfigurationService.createDb(this.jdbcConf);
            this.getEchoBaseSession().initWorkingDb(this.jdbcConf, true);
            this.addFlashMessage(this._("echobase.info.workingDb.created", new Object[]{this.conf.getUrl()}));
        }
        catch (Exception e) {
            try {
                this.getEchoBaseSession().releaseWorkingDb();
            }
            finally {
                this.metaJdbcConf = null;
                this.jdbcConf = null;
            }
            throw e;
        }
        return "success";
    }

    public void validate() {
        if (!DriverType.POSTGRESQL.equals((Object)this.getConf().getDriverType())) {
            this.addFieldError("conf.driverType", this._("echobase.error.workingDbConfiguration.createOnlyOnPostgresql", new Object[0]));
        } else {
            this.jdbcConf = JdbcConfiguration.newConfig((DriverType)this.getConf().getDriverType(), (String)this.getConf().getUrl(), (String)this.login, (String)this.password);
            this.metaJdbcConf = EchoBaseEntityHelper.newMetaWorkingDb((JdbcConfiguration)this.jdbcConf);
            try {
                EchoBaseEntityHelper.checkJDBCConnection((JdbcConfiguration)this.metaJdbcConf);
            }
            catch (SQLException e) {
                this.jdbcConf = null;
                this.addFieldError("login", this._("echobase.error.workingDbConfiguration.couldNotConnect", new Object[]{e.getMessage()}));
                this.addFieldError("password", this._("echobase.error.workingDbConfiguration.couldNotConnect", new Object[]{e.getMessage()}));
            }
        }
    }
}

