/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: EchoBaseInternalDbTransactionFilter.java 589 2012-09-02 15:11:02Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-2.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/EchoBaseInternalDbTransactionFilter.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui;

import com.opensymphony.xwork2.ActionContext;
import fr.ifremer.echobase.persistence.EchoBaseEntityHelper;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.StrutsStatics;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.web.filter.TopiaTransactionFilter;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/**
 * Inject in each request a new transaction from the internal db.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EchoBaseInternalDbTransactionFilter extends TopiaTransactionFilter {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(EchoBaseInternalDbTransactionFilter.class);

    public static TopiaContext getTransaction(ActionContext context) {
        HttpServletRequest request = (HttpServletRequest)
                context.get(StrutsStatics.HTTP_REQUEST);
        return TopiaTransactionFilter.getTransaction(request);
    }

    @Override
    protected TopiaContext beginTransaction(ServletRequest request) throws TopiaRuntimeException {
        EchoBaseApplicationContext applicationContext =
                EchoBaseActionSupport.getEchoBaseApplicationContext();

        TopiaContext rootContext = applicationContext.getInternalRootContext();
        try {
            TopiaContext transaction = rootContext.beginTransaction();
            if (log.isDebugEnabled()) {
                log.debug("Starts a new echo transaction " + transaction);
            }
            return transaction;
        } catch (TopiaException eee) {
            throw new TopiaRuntimeException("Could not start transaction", eee);
        }
    }

    /**
     * Hook method to close the topia transaction of the request at the end of
     * the request when all filter has been consumed.
     *
     * @param transaction the transaction to close (can be null if transaction
     *                    was not required while the current request)
     * @since 1.0
     */
    protected void onCloseTransaction(TopiaContext transaction) {
        //FIXME Check if this necessary any longer ?
        EchoBaseEntityHelper.closeConnection(transaction);
    }

//    public static void closeConnection(TopiaContext transaction) {
//        if (transaction == null) {
//            if (log.isTraceEnabled()) {
//                log.trace("no transaction to close");
//            }
//        } else if (transaction.isClosed()) {
//            if (log.isTraceEnabled()) {
//                log.trace("transaction " + transaction + " is already closed");
//            }
//        } else {
//            if (log.isDebugEnabled()) {
//                log.debug("closing transaction " + transaction);
//            }
//
//            try {
//                Transaction tx = ((TopiaContextImplementor) transaction).getHibernate().getTransaction();
//                if (!tx.wasCommitted() && !tx.wasRolledBack()) {
//                    if (log.isDebugEnabled()) {
//                        log.debug("rollback transaction!");
//                    }
//                    tx.rollback();
//                }
//                transaction.closeContext();
//            } catch (TopiaException e) {
//                throw new TopiaRuntimeException(e);
//            }
//        }
//    }
}
