/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: Import.java 420 2012-03-27 23:02:51Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.5/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importDb/Import.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importDb;

import fr.ifremer.echobase.services.ImportDbConfiguration;
import fr.ifremer.echobase.services.ImportDbService;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Start the import db.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class Import extends AbstractWaitAndExecAction<ImportDbConfiguration> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(Import.class);

    /** service to execute the import. */
    protected transient ImportDbService service;

    @Override
    protected ImportDbConfiguration initModel() {
        return getEchoBaseSession().getImportDbConfiguration();
    }

    @Override
    public void prepare() throws Exception {

        super.prepare();

        service = newService(ImportDbService.class);
    }

    @Override
    protected void startAction(ImportDbConfiguration model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("Start imports with file " +
                     model.getInput().getFileName());
        }

        service.importDb(model, getEchoBaseSession().getEchoBaseUser(), true);
    }

    @Override
    protected void closeAction(ImportDbConfiguration model) throws Exception {

        // clean configuration
        model.destroy();

        // remove configuration from session
        getEchoBaseSession().setImportDbConfiguration(null);
    }


}