/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: AbstractJSONPaginedAction.java 479 2012-04-03 14:03:20Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.5/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/AbstractJSONPaginedAction.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions;

import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

import java.util.Collection;
import java.util.Map;

/**
 * Abstract JSON action with pagination support.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public abstract class AbstractJSONPaginedAction extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    public abstract Integer getRows();

    public abstract Integer getPage();

    public abstract Integer getTotal();

    public abstract Integer getRecords();

    protected TopiaFilterPagerUtil.FilterPagerBean pager =
            new TopiaFilterPagerUtil.FilterPagerBean();

    // sorting order - asc or desc
    protected String sord;

    // get index row - i.e. user click to sort.
    protected String sidx;

    protected String filters;

    protected String searchField;

    protected String searchString;

    protected String searchOper;

    public void setRows(Integer rows) {
        pager.setPageSize(rows);
    }

    public void setPage(Integer page) {
        pager.setPageIndex(page);
    }

    public String getSord() {
        return sord;
    }

    public void setSord(String sord) {
        this.sord = sord;
    }

    public String getSidx() {
        return sidx;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
    }

    public String getFilters() {
        return filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public void setSearchField(String searchField) {
        this.searchField = searchField;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public void setSearchOper(String searchOper) {
        this.searchOper = searchOper;
    }

    protected String getSortColumn() {
        String result = null;
        if (useSort()) {
            result = sidx;
        }
        return result;
    }

    protected Boolean isSortAscendant() {
        Boolean result = null;
        if (useSort()) {
            result = "asc".equals(sord);
        }
        return result;
    }

    protected boolean useSort() {
        return StringUtils.isNotEmpty(sidx);
    }

    protected void initFilter() throws JSONException {

        if (StringUtils.isNotEmpty(filters)) {
            Map<String, Object> filterObject =
                    (Map<String, Object>) JSONUtil.deserialize(filters);

            String groupOp = (String) filterObject.get("groupOp");
            Collection<Map<String, String>> rules =
                    (Collection<Map<String, String>>) filterObject.get("rules");

            TopiaFilterPagerUtil.newFilterPagerBeanBuilder(groupOp).
                    addOperations(rules).
                    flush(pager);
        } else {

            // could be a single search

            if (StringUtils.isNotEmpty(searchField)) {

                Map<String, String> rule = Maps.newTreeMap();
                rule.put("op", searchOper);
                rule.put("field", searchField);
                rule.put("data", searchString);
                TopiaFilterPagerUtil.newFilterPagerBeanBuilder("AND").
                        addRule(rule).
                        flush(pager);
            }
        }


    }
}
