<%--
  #%L
  EchoBase :: UI
  
  $Id: configureResults.jsp 370 2012-03-19 07:18:36Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.3/echobase-ui/src/main/webapp/WEB-INF/jsp/importData/configureResults.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<%--script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script--%>
<title>
  Configuration <s:text name="echobase.common.importDataMode.results"/>
</title>

<script type="text/javascript">

  jQuery(document).ready(function () {

    // to change form when mode is changed
    $('[name="model.importMode"]').change(function (event) {
      $('[class~="importMode"]').hide();
      $('#' + this.value).show();
      $('#' + this.value + ' .errorMessage').hide();
    });

    // show incoming mode
    var incomingVal = $('[name="model.importMode"][checked="checked"]').val();
    $('#' + incomingVal).show();
  });
</script>

<s:radio id='mode' key='model.importMode' list="importModes"
         cssClass="cleanBoth"
         label='%{getText("echobase.common.importMode")}'
         required="true" template="myradiomap"/>

<s:form id="VOYAGE" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <s:hidden key="model.importMode" value="VOYAGE" label=''/>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <s:file key="lengthAgeKeyFile" required="true"
            label='%{getText("echobase.common.lengthAgeKeyFile")}'/>

    <s:file key="lengthWeightKeyFile" required="true"
            label='%{getText("echobase.common.lengthWeightKeyFile")}'/>

    <s:file key="echotypeFile" required="true"
            label='%{getText("echobase.common.echotypeFile")}'/>
  </fieldset>
  <br/>
  <s:submit action="ConfigureResults-modeVoyage" key='echobase.action.import'/>
</s:form>

<s:form id="ACOUSTIC_BY_ECHOTYPE" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <s:hidden key="model.importMode" value="ACOUSTIC" label=''/>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <s:textfield key="model.resultLabel" size="40" required="true"
                 label='%{getText("echobase.common.resultLabel")}'/>

    <s:file key="acousticByEchotypeFile" required="true"
            label='%{getText("echobase.common.acousticByEchotypeFile")}'/>
  </fieldset>
  <br/>
  <s:submit action="ConfigureResults-modeAcousticByEchotype"
            key='echobase.action.import'/>
</s:form>

<s:form id="ACOUSTIC_BY_ECHOTYPE_AND_SPECIES_CATEGORY" namespace="/importData"
        method="POST"
        enctype="multipart/form-data" cssClass="hidden importMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <s:hidden key="model.importMode" value="ACOUSTIC" label=''/>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <s:textfield key="model.resultLabel" size="40" required="true"
                 label='%{getText("echobase.common.resultLabel")}'/>

    <s:file key="acousticByEchotypeAndSpeciesCategoryFile" required="true"
            label='%{getText("echobase.common.acousticByEchotypeAndSpeciesCategoryFile")}'/>
  </fieldset>
  <br/>
  <s:submit action="ConfigureResults-modeAcousticByEchotypeAndSpeciesCategory"
            key='echobase.action.import'/>
</s:form>

<s:form id="REGION" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <s:hidden key="model.importMode" value="REGION" label=''/>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <s:textfield key="model.resultLabel" size="40" required="true"
                 label='%{getText("echobase.common.resultLabel")}'/>

    <s:file key="regionsFile" required="true"
            label='%{getText("echobase.common.cellRegionsFile")}'/>

    <s:file key="regionAssociationFile" required="true"
            label='%{getText("echobase.common.cellRegionAssociationFile")}'/>

    <s:file key="regionResultFile" required="true"
            label='%{getText("echobase.common.cellRegionResultFile")}'/>
  </fieldset>
  <br/>
  <s:submit action="ConfigureResults-modeRegion" key='echobase.action.import'/>
</s:form>

<s:form id="MAP" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <s:hidden key="model.importMode" value="REGION" label=''/>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <s:textfield key="model.resultLabel" size="40" required="true"
                 label='%{getText("echobase.common.resultLabel")}'/>

    <s:file key="mapsFile" required="true"
            label='%{getText("echobase.common.cellMapsFile")}'/>

    <s:file key="mapResultFile" required="true"
            label='%{getText("echobase.common.cellMapResultFile")}'/>
  </fieldset>
  <br/>
  <s:submit action="ConfigureResults-modeMap" key='echobase.action.import'/>
</s:form>
