/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.AreaOfOperation;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.configurations.CommonDataImportConfiguration;
import fr.ifremer.echobase.services.configurations.CommonDataImportMode;
import fr.ifremer.echobase.ui.actions.importData.AbstractConfigureImport;
import java.io.File;
import java.util.Map;

public class ConfigureCommonData
extends AbstractConfigureImport<CommonDataImportConfiguration> {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> missions;
    protected Map<String, String> voyages;
    protected Map<String, String> areaOfOperations;
    protected Map<String, String> importModes;

    public ConfigureCommonData() {
        super(CommonDataImportConfiguration.class);
    }

    protected CommonDataImportConfiguration createModel() {
        return new CommonDataImportConfiguration(this.getLocale());
    }

    public String input() throws Exception {
        super.input();
        EchoBaseServiceSupport service = (EchoBaseServiceSupport)this.newService(EchoBaseServiceSupport.class);
        this.missions = this.loadSortAndDecorate(service, Mission.class);
        this.voyages = this.loadSortAndDecorate(service, Voyage.class);
        this.areaOfOperations = this.loadSortAndDecorate(service, AreaOfOperation.class);
        this.importModes = this.decorateEnums((Enum[])CommonDataImportMode.values());
        if (((CommonDataImportConfiguration)this.getModel()).getImportMode() == null) {
            ((CommonDataImportConfiguration)this.getModel()).setImportMode(CommonDataImportMode.ALL);
        }
        return "input";
    }

    @InputConfig(methodName="input")
    public String modeAll() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeTransect() throws Exception {
        return this.execute();
    }

    public Map<String, String> getMissions() {
        return this.missions;
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public Map<String, String> getAreaOfOperations() {
        return this.areaOfOperations;
    }

    public Map<String, String> getImportModes() {
        return this.importModes;
    }

    public void setVoyageFile(File file) {
        ((CommonDataImportConfiguration)this.getModel()).getVoyageFile().setFile(file);
    }

    public void setVoyageFileContentType(String contentType) {
        ((CommonDataImportConfiguration)this.getModel()).getVoyageFile().setContentType(contentType);
    }

    public void setVoyageFileFileName(String fileName) {
        ((CommonDataImportConfiguration)this.getModel()).getVoyageFile().setFileName(fileName);
    }

    public void setTransitFile(File file) {
        ((CommonDataImportConfiguration)this.getModel()).getTransitFile().setFile(file);
    }

    public void setTransitFileContentType(String contentType) {
        ((CommonDataImportConfiguration)this.getModel()).getTransitFile().setContentType(contentType);
    }

    public void setTransitFileFileName(String fileName) {
        ((CommonDataImportConfiguration)this.getModel()).getTransitFile().setFileName(fileName);
    }

    public void setTransectFile(File file) {
        ((CommonDataImportConfiguration)this.getModel()).getTransectFile().setFile(file);
    }

    public void setTransectFileContentType(String contentType) {
        ((CommonDataImportConfiguration)this.getModel()).getTransectFile().setContentType(contentType);
    }

    public void setTransectFileFileName(String fileName) {
        ((CommonDataImportConfiguration)this.getModel()).getTransectFile().setFileName(fileName);
    }
}

