/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: GetUsers.java 51 2011-11-13 16:20:45Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/user/GetUsers.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.user;

import com.google.common.collect.Lists;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.entities.EchoBaseUserDTO;
import fr.ifremer.echobase.services.UserService;
import fr.ifremer.echobase.ui.actions.AbstractJSONPaginedAction;

import java.util.List;

/**
 * Obtains all users of the echobase internal database.
 *
 * @author sletellier <letellier@codelutin.com>
 * @since 0.1
 */
public class GetUsers extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    protected List<EchoBaseUserDTO> users;

    public GetUsers() {
        super("users_");
    }

    public List<EchoBaseUserDTO> getUsers() {
        return users;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageNumber();
    }

    @Override
    public Integer getTotal() {
        return pager.getPageCount();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    @Override
    public String execute() throws Exception {

        List<EchoBaseUser> allUsers =
                newService(UserService.class).getUsers(pager);

        users = Lists.newArrayList();
        for (EchoBaseUser user : allUsers) {
            users.add(user.toDTO());
        }

        return SUCCESS;
    }

}
