/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: GetForeignEntities.java 35 2011-11-11 02:13:58Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/GetForeignEntities.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.nuiton.topia.persistence.TopiaEntity;

import java.util.List;
import java.util.Map;

/**
 * Obtains the html select form for the given entity type.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class GetForeignEntities extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    protected Map<String, String> entities;

    protected String entityType;

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public Map<String, String> getEntities() {
        return entities;
    }

    @Override
    public String execute() throws Exception {

        DbEditorService service = newService(DbEditorService.class);
        List<TopiaEntity> foreignEntities = service.getForeignDatas(entityType);
        entities = sortAndDecorate(foreignEntities, null);

        return SUCCESS;
    }
}
