/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: GetEntities.java 51 2011-11-13 16:20:45Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/GetEntities.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import fr.ifremer.echobase.entities.EntityModificationLogImpl;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.ui.actions.AbstractJSONPaginedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Map;

/**
 * To obtain the data for the given request.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class GetEntities extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(GetEntities.class);

    /** Name of the table to load. */
    protected String tableName;

    /** Datas of the given table. */
    protected Map<?, ?>[] datas;

    public GetEntities() {
        super("datas_");
    }

    public Map<?, ?>[] getDatas() {
        return datas;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageNumber();
    }

    @Override
    public Integer getTotal() {
        return pager.getPageCount();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String execute() throws Exception {

        Boolean ascendantOrder = isSortAscendant();
        String sortColumn = getSortColumn();
        Object filterObject = getFilterObject();

        if (log.isDebugEnabled()) {
            log.debug("filters      = " + getFilters());
            log.debug("filterObject = " + filterObject);
            log.debug("sidx         = " + sortColumn);
            log.debug("sord         = " + ascendantOrder);
        }

        DbEditorService dbEditorService = newService(DbEditorService.class);

        datas = dbEditorService.getDatas(
                tableName,
                pager,
                sortColumn,
                ascendantOrder
        );

        if (log.isDebugEnabled()) {
            log.debug("Total page = " + getTotal());
        }

        return SUCCESS;
    }


    public String entityModificationLogs() throws Exception {
        tableName = EntityModificationLogImpl.class.getName();
        execute();
        return SUCCESS;
    }
}
