package fr.ifremer.coselmar.services;

/*
 * #%L
 * Coselmar :: Rest Services
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Locale;

import fr.ifremer.coselmar.persistence.CoselmarPersistenceContext;
import fr.ifremer.coselmar.persistence.CoselmarTopiaApplicationContext;
import fr.ifremer.coselmar.services.config.CoselmarServicesConfig;
import org.apache.commons.lang3.StringUtils;

/**
 * @author ymartel <martel@codelutin.com>
 */
public class DefaultCoselmarServicesContext implements CoselmarServicesContext {

    protected CoselmarServicesConfig servicesConfig;

    protected CoselmarPersistenceContext persistenceContext;

    protected Locale locale;

    private CoselmarTopiaApplicationContext topiaApplicationContext;

    public void setCoselmarServicesConfig(CoselmarServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public void setTopiaApplicationContext(CoselmarTopiaApplicationContext topiaApplicationContext) {
        this.topiaApplicationContext = topiaApplicationContext;
    }

    public void setPersistenceContext(CoselmarPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Date getNow() {
        Date now = new Date();
        return now;
    }

    @Override
    public CoselmarTopiaApplicationContext getTopiaApplicationContext() {
        return this.topiaApplicationContext;
    }

    @Override
    public CoselmarPersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public CoselmarServicesConfig getCoselmarServicesConfig() {
        return this.servicesConfig;
    }

    @Override
    public <E extends CoselmarService> E newService(Class<E> serviceClass) {

        E service;

        try {

            Constructor<E> constructor = serviceClass.getConstructor();

            service = constructor.newInstance();

        } catch (NoSuchMethodException e) {

            throw new CoselmarTechnicalException("all services must provide a default public constructor", e);

        } catch (InvocationTargetException | InstantiationException | IllegalAccessException e) {

            throw new CoselmarTechnicalException("unable to instantiate coselmar service", e);

        }

        service.setServicesContext(this);

        return service;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public String getCleanMail(String email) {
        return email == null ? null : StringUtils.lowerCase(email.trim());
    }

}
