/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.CommentPrinter;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.Spacing;
import EDU.purdue.jtb.syntaxtree.Node;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;

public class ClassInfo {
    private Node astNode;
    private String name;
    private Vector typeList = new Vector();
    private Vector nameList = new Vector();
    private Vector initList = new Vector();
    private boolean makeDefaultConstructor = false;

    public ClassInfo(Node node, String n) {
        this.astNode = node;
        this.name = n;
    }

    public Node getAstNode() {
        return this.astNode;
    }

    public String getName() {
        return this.name;
    }

    public Vector getTypeList() {
        return this.typeList;
    }

    public Vector getNameList() {
        return this.nameList;
    }

    public void addField(String type, String name) {
        this.addField(type, name, null);
    }

    public void addField(String type, String name, String initialValue) {
        this.typeList.addElement(type);
        this.nameList.addElement(name);
        if (initialValue == null || initialValue.equals("")) {
            this.initList.addElement(null);
        } else {
            this.initList.addElement(initialValue);
            this.makeDefaultConstructor = true;
        }
    }

    public String getEbnfProduction(Spacing space) {
        StringWriter buf = new StringWriter();
        PrintWriter out = new PrintWriter(buf);
        this.astNode.accept(new CommentPrinter(out, space));
        out.flush();
        String temp = buf.toString();
        return temp;
    }

    public String getClassString(Spacing space) {
        Enumeration inits;
        Enumeration types = this.typeList.elements();
        Enumeration names = this.nameList.elements();
        StringWriter buf = new StringWriter();
        PrintWriter out = new PrintWriter(buf);
        out.print(space.spc + "public class " + this.name);
        if (Globals.nodeSuperclass != null) {
            out.print(" extends " + Globals.nodeSuperclass);
        }
        out.println(" implements Node {");
        space.updateSpc(1);
        if (Globals.parentPointers) {
            out.println(space.spc + "private Node parent;");
        }
        while (types.hasMoreElements()) {
            out.println(space.spc + "public " + (String)types.nextElement() + " " + (String)names.nextElement() + ";");
        }
        out.println();
        out.print(space.spc + "public " + this.name + "(");
        types = this.typeList.elements();
        if (types.hasMoreElements()) {
            out.print((String)types.nextElement() + " n0");
        }
        int count = 1;
        while (types.hasMoreElements()) {
            out.print(", " + (String)types.nextElement() + " n" + count);
            ++count;
        }
        out.println(") {");
        names = this.nameList.elements();
        space.updateSpc(1);
        count = 0;
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            out.println(space.spc + name + " = n" + count + ";");
            if (Globals.parentPointers) {
                out.println(space.spc + "if ( " + name + " != null ) " + name + ".setParent(this);");
            }
            ++count;
        }
        space.updateSpc(-1);
        out.println(space.spc + "}");
        if (this.makeDefaultConstructor) {
            count = 0;
            boolean firstTime = true;
            out.println();
            out.print(space.spc + "public " + this.name + "(");
            types = this.typeList.elements();
            inits = this.initList.elements();
            while (types.hasMoreElements()) {
                String type = (String)types.nextElement();
                if (inits.nextElement() != null) continue;
                if (!firstTime) {
                    out.print(", ");
                }
                out.print(type + " n" + count);
                ++count;
                firstTime = false;
            }
            out.println(") {");
        }
        if (this.makeDefaultConstructor) {
            count = 0;
            names = this.nameList.elements();
            inits = this.initList.elements();
            space.updateSpc(1);
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String init = (String)inits.nextElement();
                if (init != null) {
                    out.println(space.spc + name + " = " + init + ";");
                } else {
                    out.println(space.spc + name + " = n" + count + ";");
                    ++count;
                }
                if (!Globals.parentPointers) continue;
                out.println(space.spc + "if ( " + name + " != null ) " + name + ".setParent(this);");
            }
            space.updateSpc(-1);
            out.println(space.spc + "}");
        }
        out.println();
        out.println(space.spc + "public void accept(" + Globals.visitorPackage + ".Visitor v) {");
        space.updateSpc(1);
        out.println(space.spc + "v.visit(this);");
        space.updateSpc(-1);
        out.println(space.spc + "}");
        out.println(space.spc + "public <R,A> R accept(" + Globals.visitorPackage + ".GJVisitor<R,A> v, A argu) {");
        space.updateSpc(1);
        out.println(space.spc + "return v.visit(this,argu);");
        space.updateSpc(-1);
        out.println(space.spc + "}");
        out.println(space.spc + "public <R> R accept(" + Globals.visitorPackage + ".GJNoArguVisitor<R> v) {");
        space.updateSpc(1);
        out.println(space.spc + "return v.visit(this);");
        space.updateSpc(-1);
        out.println(space.spc + "}");
        out.println(space.spc + "public <A> void accept(" + Globals.visitorPackage + ".GJVoidVisitor<A> v, A argu) {");
        space.updateSpc(1);
        out.println(space.spc + "v.visit(this,argu);");
        space.updateSpc(-1);
        out.println(space.spc + "}");
        if (Globals.parentPointers) {
            out.println(space.spc + "public void setParent(Node n) { parent = n; }");
            out.println(space.spc + "public Node getParent()       { return parent; }");
        }
        space.updateSpc(-1);
        out.println(space.spc + "}");
        out.flush();
        out.close();
        return buf.toString();
    }
}

