/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAddMemberResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAddMemberRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcAddMember {
    private String groupName;
    private String groupUuid;
    private Timestamp disabledTime;
    private Timestamp enabledTime;
    private List<WsSubjectLookup> subjectLookups = new ArrayList<WsSubjectLookup>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private Boolean replaceAllExisting = null;
    private WsSubjectLookup actAsSubject;
    private String fieldName;
    private GcTransactionType txType;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private String clientVersion;

    public void assignDisabledTime(Timestamp theDisabledTime) {
        this.disabledTime = theDisabledTime;
    }

    public void assignEnabledTime(Timestamp theEnabledTime) {
        this.enabledTime = theEnabledTime;
    }

    public GcAddMember assignGroupName(String theGroupName) {
        this.groupName = theGroupName;
        return this;
    }

    public GcAddMember assignGroupUuid(String theGroupUuid) {
        this.groupUuid = theGroupUuid;
        return this;
    }

    public GcAddMember addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcAddMember addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcAddMember addSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.subjectLookups.add(wsSubjectLookup);
        return this;
    }

    public GcAddMember addSubjectId(String subjectId) {
        this.subjectLookups.add(new WsSubjectLookup(subjectId, null, null));
        return this;
    }

    public GcAddMember addSubjectIdentifier(String subjectIdentifier) {
        this.subjectLookups.add(new WsSubjectLookup(null, null, subjectIdentifier));
        return this;
    }

    public GcAddMember assignReplaceAllExisting(Boolean isReplaceAllExisting) {
        this.replaceAllExisting = isReplaceAllExisting;
        return this;
    }

    public GcAddMember assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.isBlank(this.groupName) && GrouperClientUtils.isBlank(this.groupUuid)) {
            throw new RuntimeException("Group name or uuid is required: " + this);
        }
        if (GrouperClientUtils.isNotBlank(this.groupName) && GrouperClientUtils.isNotBlank(this.groupUuid)) {
            throw new RuntimeException("Group name and uuid cannot both be filled in at once: " + this);
        }
        if (!(GrouperClientUtils.length(this.subjectLookups) != 0 || this.replaceAllExisting != null && this.replaceAllExisting.booleanValue())) {
            throw new RuntimeException("Need at least one subject to add to group: " + this);
        }
    }

    public GcAddMember assignFieldName(String theFieldName) {
        this.fieldName = theFieldName;
        return this;
    }

    public GcAddMember assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public GcAddMember addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcAddMember assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcAddMember assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public GcAddMember assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public WsAddMemberResults execute() {
        this.validate();
        WsAddMemberResults wsAddMemberResults = null;
        try {
            WsRestAddMemberRequest addMember = new WsRestAddMemberRequest();
            addMember.setActAsSubjectLookup(this.actAsSubject);
            addMember.setFieldName(this.fieldName);
            addMember.setTxType(this.txType == null ? null : this.txType.name());
            if (this.replaceAllExisting != null) {
                addMember.setReplaceAllExisting(this.replaceAllExisting != false ? "T" : "F");
            }
            if (this.includeGroupDetail != null) {
                addMember.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                addMember.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            WsGroupLookup wsGroupLookup = new WsGroupLookup();
            wsGroupLookup.setGroupName(this.groupName);
            wsGroupLookup.setUuid(this.groupUuid);
            addMember.setWsGroupLookup(wsGroupLookup);
            if (this.subjectAttributeNames.size() > 0) {
                addMember.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            WsSubjectLookup[] subjectLookupsResults = GrouperClientUtils.toArray(this.subjectLookups, WsSubjectLookup.class);
            addMember.setSubjectLookups(subjectLookupsResults);
            if (this.params.size() > 0) {
                addMember.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            addMember.setDisabledTime(GrouperClientUtils.dateToString(this.disabledTime));
            addMember.setEnabledTime(GrouperClientUtils.dateToString(this.enabledTime));
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            String urlSuffix = "groups";
            wsAddMemberResults = (WsAddMemberResults)grouperClientWs.executeService(urlSuffix, addMember, "addMember", this.clientVersion);
            String resultMessage = wsAddMemberResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsAddMemberResults, wsAddMemberResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAddMemberResults;
    }
}

