/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tlv.common;

import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.tlv.common.TlvFormatException;
import de.intarsys.tools.tlv.common.TlvInputStream;
import de.intarsys.tools.tlv.common.TlvTemplate;

public abstract class TlvElement {
    protected final int identifier;
    protected final byte[] buffer;
    protected final int offset;
    protected final int length;

    protected TlvElement(int n, byte[] byArray) {
        this(n, byArray, 0, byArray.length);
    }

    protected TlvElement(int n, byte[] byArray, int n2, int n3) {
        assert (byArray != null);
        assert (byArray.length >= n2 + n3);
        this.identifier = n;
        this.buffer = byArray;
        this.offset = n2;
        this.length = n3;
    }

    public abstract TlvInputStream createTlvInputStream(byte[] var1, int var2, int var3);

    public byte[] getContent() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.buffer, this.offset, byArray, 0, this.length);
        return byArray;
    }

    public abstract byte[] getEncoded();

    public int getIdentifier() {
        return this.identifier;
    }

    public int getLength() {
        return this.length;
    }

    public TlvTemplate getTemplate() throws TlvFormatException {
        return new TlvTemplate(this.createTlvInputStream(this.buffer, this.offset, this.length));
    }

    public abstract boolean isComposite();

    public String toString() {
        return "0x" + Integer.toHexString(this.getIdentifier()) + ":" + HexTools.bytesToHexString(this.buffer, this.offset, this.length, true);
    }
}

