/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import de.intarsys.tools.collection.Entry;
import de.intarsys.tools.reader.TaggedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class ReaderTools {
    private static final Map<Character, String> escapes = new HashMap<Character, String>();

    static {
        escapes.put(new Character('\\'), "\\");
        escapes.put(new Character('\"'), "\"");
        escapes.put(new Character('n'), "\n");
        escapes.put(new Character('r'), "\r");
        escapes.put(new Character('t'), "\t");
        escapes.put(new Character('\n'), null);
        escapes.put(new Character('\r'), null);
        escapes.put(new Character('\t'), null);
        escapes.put(new Character(' '), null);
    }

    public static InputStreamReader createReaderScanBom(InputStream inputStream) throws IOException {
        String string = null;
        inputStream.mark(4);
        int n = inputStream.read();
        if (n == 0) {
            n = inputStream.read();
            if (n == 0 && (n = inputStream.read()) == 254 && (n = inputStream.read()) == 255) {
                string = "UTF-32BE";
            }
        } else if (n == 255) {
            n = inputStream.read();
            if (n == 254) {
                inputStream.mark(4);
                n = inputStream.read();
                if (n == 0 && (n = inputStream.read()) == 0) {
                    string = "UTF-32LE";
                }
                if (string == null) {
                    inputStream.reset();
                    string = "UTF-16LE";
                }
            }
        } else if (n == 254) {
            n = inputStream.read();
            if (n == 255) {
                string = "UTF-16BE";
            }
        } else if (n == 239 && (n = inputStream.read()) == 187 && (n = inputStream.read()) == 191) {
            string = "UTF-8";
        }
        if (string == null) {
            inputStream.reset();
            return null;
        }
        return new InputStreamReader(inputStream, string);
    }

    public static InputStreamReader createReaderScanMeta(final InputStream inputStream) throws IOException {
        Reader reader = new Reader(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void mark(int n) throws IOException {
                inputStream.mark(n);
            }

            @Override
            public boolean markSupported() {
                return inputStream.markSupported();
            }

            @Override
            public int read() throws IOException {
                return inputStream.read();
            }

            @Override
            public int read(char[] cArray, int n, int n2) throws IOException {
                return -1;
            }

            @Override
            public void reset() throws IOException {
                inputStream.reset();
            }
        };
        String string = ReaderTools.readMetaEncoding(reader);
        if (string != null) {
            return new InputStreamReader(inputStream, string);
        }
        return null;
    }

    public static TaggedReader createTaggedReader(InputStream inputStream, String string, int n) throws IOException {
        InputStreamReader inputStreamReader = ReaderTools.createReaderScanBom(inputStream);
        if (inputStreamReader == null && (inputStreamReader = ReaderTools.createReaderScanMeta(inputStream)) == null) {
            inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        }
        TaggedReader taggedReader = new TaggedReader(inputStreamReader, n);
        return taggedReader;
    }

    public static Map.Entry<String, String> readEntry(Reader reader, char c) throws IOException {
        String string = "";
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        while (true) {
            int n;
            if ((n = reader.read()) == 61 && bl) {
                string = stringBuffer.toString().trim();
                stringBuffer.setLength(0);
                bl = false;
                continue;
            }
            if (n == 92 && bl2) {
                n = reader.read();
                if (n == -1) continue;
                String string3 = escapes.get(new Character((char)n));
                stringBuffer.append(string3);
                continue;
            }
            if (n == 34 && !bl) {
                if (bl2) {
                    bl2 = false;
                    bl3 = true;
                    continue;
                }
                if (stringBuffer.length() == 0) {
                    bl2 = true;
                    continue;
                }
                if (bl3) continue;
                stringBuffer.append((char)n);
                continue;
            }
            if (n == -1) {
                if (bl) {
                    string = stringBuffer.toString().trim();
                    string2 = "";
                } else {
                    string2 = stringBuffer.toString();
                }
                if (string.length() > 0) {
                    return new Entry<String, String>(string, string2);
                }
                if (string2.length() > 0) {
                    return new Entry<String, String>(string, string2);
                }
                return null;
            }
            if (n == 13 && !bl2 && c == '\n') continue;
            if (n == c && !bl2) {
                if (bl) {
                    string = stringBuffer.toString().trim();
                    string2 = "";
                } else {
                    string2 = stringBuffer.toString();
                }
                if (string.length() > 0) {
                    return new Entry<String, String>(string, string2);
                }
                if (string2.length() > 0) {
                    return new Entry<String, String>(string, string2);
                }
                return new Entry<Object, Object>(null, null);
            }
            if (bl3) continue;
            stringBuffer.append((char)n);
        }
    }

    public static Map<String, String> readMetaData(Reader reader) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (true) {
            reader.mark(1024);
            int n = reader.read();
            if (n != 36 || (n = reader.read()) != 36 || (n = reader.read()) != 36) break;
            Map.Entry<String, String> entry = ReaderTools.readEntry(reader, '\n');
            if (entry.getKey() == null) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        reader.reset();
        return hashMap;
    }

    public static String readMetaEncoding(Reader reader) throws IOException {
        Map.Entry<String, String> entry;
        reader.mark(1024);
        int n = reader.read();
        if (n == 36 && (n = reader.read()) == 36 && (n = reader.read()) == 36 && "encoding".equals((entry = ReaderTools.readEntry(reader, '\n')).getKey())) {
            reader.reset();
            return entry.getValue();
        }
        reader.reset();
        return null;
    }

    public static String readToken(Reader reader, char c) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            int n;
            if ((n = reader.read()) == 92 && bl) {
                n = reader.read();
                if (n == -1) continue;
                String string = escapes.get(new Character((char)n));
                stringBuffer.append(string);
                continue;
            }
            if (n == 13 && !bl && c == '\n') continue;
            if (n == 34) {
                if (bl) {
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (stringBuffer.length() == 0) {
                    bl = true;
                    continue;
                }
                if (bl2) continue;
                stringBuffer.append((char)n);
                continue;
            }
            if (n == -1) {
                if (stringBuffer.length() == 0) {
                    return null;
                }
                return stringBuffer.toString();
            }
            if (n == c && !bl) {
                return stringBuffer.toString();
            }
            if (bl2) continue;
            stringBuffer.append((char)n);
        }
    }
}

