/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.collection.IntervalIterator;
import de.intarsys.tools.number.NumberWrapper;
import java.util.Collection;
import java.util.Iterator;

public class NumberInterval
extends NumberWrapper {
    public static char SEPARATOR = (char)45;
    private Number from;
    private Number to;
    private double step = 1.0;

    @Override
    public boolean add(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (number.doubleValue() < this.from.doubleValue()) {
                this.from = new Double(number.doubleValue());
            } else if (number.doubleValue() > this.to.doubleValue()) {
                this.to = new Double(number.doubleValue());
            }
            return true;
        }
        if (object instanceof NumberWrapper) {
            NumberWrapper numberWrapper = (NumberWrapper)object;
            if (numberWrapper.getMin() < this.getMin()) {
                this.from = new Double(numberWrapper.getMin());
            }
            if (numberWrapper.getMax() > this.getMax()) {
                this.to = new Double(numberWrapper.getMax());
            }
        }
        throw new IllegalArgumentException("Only objects of type Number or NumberWrapper are supported.");
    }

    @Override
    public boolean addAll(Collection collection) {
        for (Object e : collection) {
            if (this.add(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.doubleValue() >= this.from.doubleValue() && number.doubleValue() <= this.to.doubleValue();
        }
        if (object instanceof NumberWrapper) {
            NumberWrapper numberWrapper = (NumberWrapper)object;
            return numberWrapper.getMin() >= this.getMin() && numberWrapper.getMax() <= this.getMax();
        }
        return false;
    }

    public Number getFrom() {
        return this.from;
    }

    @Override
    protected double getMax() {
        return this.to.doubleValue();
    }

    @Override
    protected double getMin() {
        return this.from.doubleValue();
    }

    public Number getTo() {
        return this.to;
    }

    @Override
    public NumberWrapper increment(int n) {
        this.from = new Integer(this.getFrom().intValue() + n);
        this.to = new Integer(this.getTo().intValue() + n);
        return this;
    }

    @Override
    public boolean isEmpty() {
        if (this.to == null || this.from == null) {
            return true;
        }
        return this.from.intValue() > this.to.intValue();
    }

    @Override
    public Iterator iterator() {
        return new IntervalIterator(this.from, this.to);
    }

    public void setFrom(Number number) {
        this.from = number;
    }

    public void setTo(Number number) {
        this.to = number;
    }

    @Override
    public int size() {
        return (int)Math.round((this.to.doubleValue() - this.from.doubleValue()) / this.step) + 1;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Number[this.size()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = new Double(this.from.doubleValue() + (double)n * this.step);
            ++n;
        }
        return objectArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getFrom());
        stringBuilder.append(SEPARATOR);
        stringBuilder.append(this.getTo());
        return stringBuilder.toString();
    }
}

